/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.codahale.ExponentiallyDecayingReservoir;
import com.alibaba.jstorm.common.metric.codahale.JHistogram;
import com.alibaba.jstorm.common.metric.snapshot.AsmHistogramSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmSnapshot;
import com.alibaba.jstorm.metric.JStormMetrics;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AsmHistogram
extends AsmMetric<JHistogram> {
    private final Map<Integer, JHistogram> histogramMap = new ConcurrentHashMap<Integer, JHistogram>();
    private JHistogram unFlushed = this.newHistogram();
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private static volatile long updateInterval = 10L;
    private volatile long lastUpdateTime = System.currentTimeMillis();

    public AsmHistogram() {
        Iterator i$ = windowSeconds.iterator();
        while (i$.hasNext()) {
            int win = (Integer)i$.next();
            this.histogramMap.put(win, this.newHistogram());
        }
    }

    public AsmHistogram(TimeUnit timeUnit) {
        this();
        this.setTimeUnit(timeUnit);
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        if (timeUnit != TimeUnit.MILLISECONDS && timeUnit != TimeUnit.NANOSECONDS) {
            throw new RuntimeException("bad time unit, only ms & ns are supported!");
        }
        this.timeUnit = timeUnit;
    }

    public long getTime() {
        long now;
        long elapsed;
        if (JStormMetrics.enabled && (elapsed = (now = System.currentTimeMillis()) - this.lastUpdateTime) >= updateInterval) {
            this.lastUpdateTime = now;
            if (this.timeUnit == TimeUnit.MILLISECONDS) {
                return now;
            }
            return System.nanoTime();
        }
        return -1L;
    }

    public boolean okToUpdate(long now) {
        return now - this.lastUpdateTime >= updateInterval;
    }

    @Override
    public void update(Number obj) {
        if (JStormMetrics.enabled && this.sample() && this.enabled.get()) {
            this.unFlushed.update(obj.longValue());
        }
    }

    @Override
    public void updateTime(long start) {
        if (JStormMetrics.enabled && this.sample() && this.enabled.get() && start >= 0L) {
            if (this.timeUnit == TimeUnit.MILLISECONDS) {
                long end = System.currentTimeMillis();
                this.unFlushed.update((end - start) * 1000L);
            } else {
                long end = System.nanoTime();
                this.unFlushed.update((end - start) / 1000L);
            }
        }
    }

    public void setLastUpdateTime(long time) {
        this.lastUpdateTime = time;
    }

    @Override
    public void updateDirectly(Number obj) {
        this.unFlushed.update(obj.longValue());
    }

    @Override
    public Map<Integer, JHistogram> getWindowMetricMap() {
        return this.histogramMap;
    }

    @Override
    public JHistogram mkInstance() {
        return this.newHistogram();
    }

    @Override
    protected void updateSnapshot(int window) {
        JHistogram histogram = this.histogramMap.get(window);
        if (histogram != null) {
            AsmSnapshot snapshot = new AsmHistogramSnapshot().setSnapshot(histogram.getSnapshot()).setTs(System.currentTimeMillis()).setMetricId(this.metricId);
            this.snapshots.put(window, snapshot);
        }
    }

    @Override
    protected void doFlush() {
        long[] values = this.unFlushed.getSnapshot().getValues();
        for (JHistogram histogram : this.histogramMap.values()) {
            for (long val : values) {
                histogram.update(val);
            }
        }
        for (long val : values) {
            for (AsmMetric metric : this.assocMetrics) {
                metric.updateDirectly(val);
            }
        }
        this.unFlushed = this.newHistogram();
    }

    @Override
    public AsmMetric clone() {
        return new AsmHistogram(this.timeUnit);
    }

    private JHistogram newHistogram() {
        return new JHistogram(new ExponentiallyDecayingReservoir());
    }

    public static void setUpdateInterval(long interval) {
        if (interval < 0L || interval > 1000L) {
            throw new RuntimeException("timerUpdateInterval must be between 0~1000");
        }
        updateInterval = interval;
    }

    public static long getUpdateInterval() {
        return updateInterval;
    }
}

