/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.codahale.JMeter;
import com.alibaba.jstorm.common.metric.snapshot.AsmMeterSnapshot;
import com.codahale.metrics.Meter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AsmMeter
extends AsmMetric<Meter> {
    private static final long UPDATE_INTERVAL_MS = 3000L;
    private final JMeter meter = new JMeter();
    private final AtomicLong unflushed = new AtomicLong(0L);
    private volatile long lastUpdateTime = System.currentTimeMillis();

    public void mark() {
        this.unflushed.addAndGet(1L);
    }

    @Override
    public void update(Number obj) {
        if (this.enabled.get()) {
            this.unflushed.addAndGet(obj.longValue());
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastUpdateTime;
            if (elapsed >= 3000L) {
                this.lastUpdateTime = now;
                this.doFlush();
            }
        }
    }

    @Override
    public void updateTime(long obj) {
        throw new RuntimeException("please use update method!");
    }

    @Override
    public AsmMetric clone() {
        return new AsmMeter();
    }

    @Override
    public Map<Integer, Meter> getWindowMetricMap() {
        return null;
    }

    @Override
    protected void doFlush() {
        long v = this.unflushed.getAndSet(0L);
        this.meter.mark(v);
        for (AsmMetric metric : this.assocMetrics) {
            metric.update(v);
        }
    }

    @Override
    protected void updateSnapshot(int window) {
        AsmMeterSnapshot meterSnapshot = new AsmMeterSnapshot();
        meterSnapshot.setM1(this.meter.getOneMinuteRate()).setM5(this.meter.getFiveMinuteRate()).setM15(this.meter.getFifteenMinuteRate()).setMean(this.meter.getMeanRate()).setTs(System.currentTimeMillis()).setMetricId(this.metricId);
        this.snapshots.put(window, meterSnapshot);
    }

    @Override
    public Meter mkInstance() {
        return null;
    }
}

