/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import backtype.storm.utils.MutableInt;
import com.alibaba.jstorm.common.metric.AsmCounter;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMeter;
import com.alibaba.jstorm.common.metric.snapshot.AsmSnapshot;
import com.alibaba.jstorm.metric.AsmWindow;
import com.alibaba.jstorm.metric.MetaType;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.utils.TimeUtils;
import com.codahale.metrics.Metric;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsmMetric<T extends Metric> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Joiner JOINER = Joiner.on((String)".");
    protected static final List<Integer> windowSeconds = Lists.newArrayList((Object[])new Integer[]{AsmWindow.M1_WINDOW, AsmWindow.M10_WINDOW, AsmWindow.H2_WINDOW, AsmWindow.D1_WINDOW});
    protected static final List<Integer> nettyWindows = Lists.newArrayList((Object[])new Integer[]{AsmWindow.M1_WINDOW});
    protected static int minWindow = AsmMetric.getMinWindow(windowSeconds);
    protected static final List<Integer> EMPTY_WIN = Lists.newArrayListWithCapacity((int)0);
    private static double sampleRate = 0.05;
    protected int op = 2;
    protected volatile long metricId = 0L;
    protected String metricName;
    protected boolean aggregate = true;
    protected AtomicBoolean enabled = new AtomicBoolean(true);
    protected volatile long lastFlushTime = TimeUtils.current_time_secs() - AsmWindow.M1_WINDOW;
    protected Map<Integer, Long> rollingTimeMap = new ConcurrentHashMap<Integer, Long>();
    protected Map<Integer, Boolean> rollingDirtyMap = new ConcurrentHashMap<Integer, Boolean>();
    protected final Map<Integer, AsmSnapshot> snapshots = new ConcurrentHashMap<Integer, AsmSnapshot>();
    protected Set<AsmMetric> assocMetrics = new HashSet<AsmMetric>();
    private final Random rand = new Random();
    private final int freq = (int)(1.0 / sampleRate);
    private MutableInt curr = new MutableInt(-1);
    private MutableInt target = new MutableInt(this.rand.nextInt(this.freq));

    public AsmMetric() {
        for (Integer win : windowSeconds) {
            this.rollingTimeMap.put(win, this.lastFlushTime);
            this.rollingDirtyMap.put(win, false);
        }
    }

    protected boolean sample() {
        if (this.curr.increment() >= this.freq) {
            this.curr.set(0);
            this.target.set(this.rand.nextInt(this.freq));
        }
        return this.curr.get() == this.target.get();
    }

    public static void setSampleRate(double sampleRate) {
        AsmMetric.sampleRate = sampleRate;
    }

    public abstract void update(Number var1);

    public abstract void updateTime(long var1);

    public void updateDirectly(Number obj) {
        this.update(obj);
    }

    public abstract AsmMetric clone();

    public AsmMetric setOp(int op) {
        this.op = op;
        return this;
    }

    public int getOp() {
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowSeconds(List<Integer> windows) {
        List<Integer> list2 = windowSeconds;
        synchronized (list2) {
            windowSeconds.clear();
            windowSeconds.addAll(windows);
            minWindow = AsmMetric.getMinWindow(windows);
        }
    }

    public static int getMinWindow(List<Integer> windows) {
        int min = Integer.MAX_VALUE;
        for (int win : windows) {
            if (win >= min) continue;
            min = win;
        }
        return min;
    }

    public void addAssocMetrics(AsmMetric ... metrics) {
        Collections.addAll(this.assocMetrics, metrics);
    }

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public void flush() {
        long time = TimeUtils.current_time_secs();
        List<Integer> windows = this.getValidWindows();
        if (windows.size() == 0) {
            return;
        }
        this.doFlush();
        List<Integer> rollWindows = this.rollWindows(time, windows);
        for (int win : windows) {
            if (rollWindows.contains(win)) {
                this.updateSnapshot(win);
                Map<Integer, T> metricMap = this.getWindowMetricMap();
                if (metricMap == null) continue;
                metricMap.put(win, this.mkInstance());
                continue;
            }
            if (this.rollingDirtyMap.get(win).booleanValue()) continue;
            this.updateSnapshot(win);
        }
        this.lastFlushTime = TimeUtils.current_time_secs();
    }

    public List<Integer> rollWindows(long time, List<Integer> windows) {
        ArrayList<Integer> rolling = new ArrayList<Integer>();
        for (Integer win : windows) {
            long rollingTime = this.rollingTimeMap.get(win);
            if (time - rollingTime < (long)(win - 5)) continue;
            rolling.add(win);
            this.rollingDirtyMap.put(win, true);
            this.rollingTimeMap.put(win, Long.valueOf(TimeUtils.current_time_secs()));
        }
        return rolling;
    }

    protected abstract void doFlush();

    public abstract Map<Integer, T> getWindowMetricMap();

    public abstract T mkInstance();

    protected abstract void updateSnapshot(int var1);

    public Map<Integer, AsmSnapshot> getSnapshots() {
        return this.snapshots;
    }

    public List<Integer> getValidWindows() {
        if (!this.enabled.get()) {
            return EMPTY_WIN;
        }
        long diff = (long)TimeUtils.current_time_secs() - this.lastFlushTime + 5L;
        if (diff < (long)minWindow) {
            return EMPTY_WIN;
        }
        if (this instanceof AsmGauge || this.metricName.startsWith(MetaType.NETTY.getV())) {
            return nettyWindows;
        }
        return windowSeconds;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public AsmMetric setEnabled(boolean enabled) {
        this.enabled.set(enabled);
        return this;
    }

    public static String mkName(Object ... parts) {
        return JOINER.join(parts);
    }

    public static class Builder {
        public static AsmMetric build(MetricType metricType) {
            AsmMetric metric;
            if (metricType == MetricType.COUNTER) {
                metric = new AsmCounter();
            } else if (metricType == MetricType.METER) {
                metric = new AsmMeter();
            } else if (metricType == MetricType.HISTOGRAM) {
                metric = new AsmHistogram();
            } else {
                throw new IllegalArgumentException("invalid metric type:" + (Object)((Object)metricType));
            }
            return metric;
        }
    }

    public static class MetricOp {
        public static final int LOG = 1;
        public static final int REPORT = 2;
    }
}

