/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.metric.Bytes;
import com.alibaba.jstorm.metric.KVSerializable;
import java.util.Date;

public abstract class MetricBaseData
implements KVSerializable {
    protected long metricId;
    protected int win;
    protected Date ts;

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public Date getTs() {
        return this.ts;
    }

    public void setTs(Date ts) {
        this.ts = ts;
    }

    public int getWin() {
        return this.win;
    }

    public void setWin(int win) {
        this.win = win;
    }

    @Override
    public byte[] getKey() {
        return MetricBaseData.makeKey(this.metricId, this.win, this.ts.getTime());
    }

    public static byte[] makeKey(long metricId, int win, long ts) {
        byte[] ret = new byte[20];
        Bytes.putLong(ret, 0, metricId);
        Bytes.putInt(ret, 8, win);
        Bytes.putLong(ret, 12, ts);
        return ret;
    }

    protected void parseKey(byte[] key) {
        this.metricId = Bytes.toLong(key, 0, 8);
        this.win = Bytes.toInt(key, 8, 4);
        this.ts = new Date(Bytes.toLong(key, 12, 8));
    }
}

