/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.common.metric.MetricMetaParser;
import com.alibaba.jstorm.metric.KVSerializable;
import com.alibaba.jstorm.metric.MetaType;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Date;

public class MetricMeta
implements KVSerializable {
    private long id;
    private String sid;
    private String clusterName;
    private String topologyId;
    private int metricType;
    private String metricGroup = "sys";
    private String metricName;
    private Date gmtCreate = new Date();
    private String component = "";
    private int taskId = 0;
    private String streamId = "";
    private int metaType;
    private String host = "";
    private int port = 0;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        this.sid = id + "";
    }

    public String getSid() {
        return this.sid;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMetricType() {
        return this.metricType;
    }

    public void setMetricType(int metricType) {
        this.metricType = metricType;
    }

    public String getMetricGroup() {
        return this.metricGroup;
    }

    public void setMetricGroup(String metricGroup) {
        this.metricGroup = metricGroup;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public int getMetaType() {
        return this.metaType;
    }

    public void setMetaType(int metaType) {
        this.metaType = metaType;
    }

    public boolean isWorkerMetric() {
        return this.metaType == MetaType.NETTY.getT() || this.getMetaType() == MetaType.WORKER.getT() || this.metaType == MetaType.TOPOLOGY.getT();
    }

    public String getFQN() {
        MetaType meta = MetaType.parse(this.metaType);
        MetricType metric = MetricType.parse(this.metricType);
        String types = meta.getV() + metric.getV();
        if (this.isWorkerMetric()) {
            return MetricUtils.concat2(types, this.topologyId, this.host, this.port, this.metricGroup, this.metricName);
        }
        return MetricUtils.concat2(types, this.topologyId, this.component, this.taskId, this.streamId, this.metricGroup, this.metricName);
    }

    @Override
    public byte[] getKey() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.clusterName).append('@').append(this.topologyId).append('@').append(this.metaType).append('@').append(this.id);
        return sb.toString().getBytes();
    }

    @Override
    public byte[] getValue() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.component).append('@').append(this.taskId).append('@').append(this.streamId).append('@').append(this.metricType).append('@').append(this.host).append('@').append(this.port).append('@').append(this.metricGroup).append('@').append(this.metricName);
        return sb.toString().getBytes();
    }

    @Override
    public Object fromKV(byte[] key, byte[] value) {
        String[] valueParts;
        String[] keyParts = new String(key).split("@");
        if (keyParts.length >= 4) {
            this.clusterName = keyParts[0];
            this.topologyId = keyParts[1];
            this.metaType = Integer.valueOf(keyParts[2]);
            this.id = Long.valueOf(keyParts[3]);
            this.sid = this.id + "";
        }
        if ((valueParts = new String(value).split("@")).length >= 8) {
            this.component = valueParts[0];
            this.taskId = JStormUtils.parseInt(valueParts[1], 0);
            this.streamId = valueParts[2];
            this.metricType = JStormUtils.parseInt(valueParts[3], 0);
            this.host = valueParts[4];
            this.port = JStormUtils.parseInt(valueParts[5], 0);
            this.metricGroup = valueParts[6];
            this.metricName = valueParts[7];
        }
        return this;
    }

    public static MetricMeta parse(String name) {
        return MetricMetaParser.fromMetricName(name);
    }
}

