/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import backtype.storm.utils.DisruptorQueue;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueGauge
extends HealthCheck
implements Gauge<Double> {
    private static final Logger LOG = LoggerFactory.getLogger(QueueGauge.class);
    public static final String QUEUE_IS_FULL = " is full";
    DisruptorQueue queue;
    String name;
    HealthCheck.Result healthy;

    public QueueGauge(DisruptorQueue queue, String ... names) {
        this.queue = queue;
        this.name = Joiner.on((String)"-").join((Object[])names);
        this.healthy = HealthCheck.Result.healthy();
    }

    public Double getValue() {
        return this.queue.pctFull();
    }

    protected HealthCheck.Result check() throws Exception {
        Double ret = this.queue.pctFull();
        if (ret > 0.9) {
            return HealthCheck.Result.unhealthy((String)(this.name + QUEUE_IS_FULL));
        }
        return this.healthy;
    }
}

