/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.metric.KVSerializable;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Date;

public class TaskTrack
implements KVSerializable {
    private long id;
    private String clusterName;
    private String topologyId;
    private String component;
    private int taskId;
    private String host;
    private int port;
    private Date start;
    private Date end;

    public TaskTrack() {
    }

    public TaskTrack(String clusterName, String topologyId) {
        this.clusterName = clusterName;
        this.topologyId = topologyId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    @Override
    public byte[] getKey() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.clusterName).append('@').append(this.topologyId).append('@').append(this.taskId).append('@');
        if (this.start != null) {
            sb.append(this.start.getTime());
        } else {
            sb.append(this.end.getTime());
        }
        return sb.toString().getBytes();
    }

    @Override
    public byte[] getValue() {
        StringBuilder sb = new StringBuilder(32);
        if (this.start != null) {
            sb.append("S");
        } else {
            sb.append("E");
        }
        sb.append('@').append(this.host).append('@').append(this.port);
        return sb.toString().getBytes();
    }

    @Override
    public Object fromKV(byte[] key, byte[] value) {
        String[] keyParts = new String(key).split("@");
        String[] valueParts = new String(value).split("@");
        boolean isStart = false;
        if (valueParts.length >= 3) {
            if (valueParts[0].equals("S")) {
                isStart = true;
            }
            this.host = valueParts[1];
            this.port = JStormUtils.parseInt(valueParts[2]);
        }
        if (keyParts.length >= 4) {
            this.clusterName = keyParts[0];
            this.topologyId = keyParts[1];
            this.taskId = JStormUtils.parseInt(keyParts[2]);
            long ts = JStormUtils.parseLong(keyParts[3]);
            if (isStart) {
                this.start = new Date(ts);
            } else {
                this.end = new Date(ts);
            }
        }
        return this;
    }

    public Date getTime() {
        return this.start != null ? this.start : this.end;
    }

    public String getIdentity() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clusterName).append('@').append(this.topologyId).append('@').append(this.taskId).append('@').append(this.host).append('@').append(this.port);
        return sb.toString();
    }

    public void merge(TaskTrack taskTrack) {
        if (taskTrack.start != null && this.start == null) {
            this.start = taskTrack.start;
        }
        if (taskTrack.end != null && this.end == null) {
            this.end = taskTrack.end;
        }
    }
}

