/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.codahale.metrics.Gauge;

public class TimerRatio
implements Gauge<Double> {
    private long lastUpdateTime = 0L;
    private long sum = 0L;
    private long lastGaugeTime = 0L;

    public synchronized void start() {
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = System.nanoTime();
        }
    }

    public synchronized void stop() {
        if (this.lastUpdateTime != 0L) {
            long now = System.nanoTime();
            long cost = now - this.lastUpdateTime;
            this.lastUpdateTime = 0L;
            this.sum += cost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getValue() {
        TimerRatio timerRatio = this;
        synchronized (timerRatio) {
            this.stop();
            long now = System.nanoTime();
            long cost = now - this.lastGaugeTime;
            if (cost == 0L) {
                return 1.0;
            }
            this.lastGaugeTime = now;
            double ratio = (double)this.sum / (double)cost;
            this.sum = 0L;
            return ratio;
        }
    }
}

