/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.metric.KVSerializable;
import com.alibaba.jstorm.metric.MetricUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Date;

public class TopologyHistory
implements KVSerializable {
    private long id;
    private String clusterName;
    private String topologyName;
    private String topologyId;
    private double sampleRate;
    private Date start;
    private Date end;

    public TopologyHistory() {
    }

    public TopologyHistory(String clusterName, String topologyId) {
        this.clusterName = clusterName;
        this.topologyId = topologyId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getTime() {
        return this.start != null ? this.start : this.end;
    }

    public String getTag() {
        return this.start != null ? "S" : "E";
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate == null ? 1.0 : sampleRate;
    }

    @Override
    public byte[] getKey() {
        return MetricUtils.concat2(this.clusterName, this.topologyName, this.getTime().getTime()).getBytes();
    }

    @Override
    public byte[] getValue() {
        return MetricUtils.concat2(this.topologyId, this.getTag(), this.sampleRate).getBytes();
    }

    @Override
    public Object fromKV(byte[] key, byte[] value) {
        String[] valueParts;
        String[] keyParts = new String(key).split("@");
        long time = 0L;
        if (keyParts.length >= 3) {
            this.clusterName = keyParts[0];
            this.topologyName = keyParts[1];
            time = Long.valueOf(keyParts[2]);
        }
        if ((valueParts = new String(value).split("@")).length >= 3) {
            this.topologyId = valueParts[0];
            String tag = valueParts[1];
            if (tag.equals("S")) {
                this.start = new Date(time);
            } else {
                this.end = new Date(time);
            }
            this.sampleRate = JStormUtils.parseDouble(valueParts[2], 0.1);
        }
        return this;
    }

    public String getIdentity() {
        return MetricUtils.concat2(this.clusterName, this.topologyId);
    }

    public void merge(TopologyHistory history) {
        if (history.start != null && this.start == null) {
            this.start = history.start;
        }
        if (history.end != null && this.end == null) {
            this.end = history.end;
        }
    }
}

