/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.codahale;

import com.alibaba.jstorm.common.metric.codahale.EWMA;
import com.alibaba.jstorm.common.metric.codahale.LongAdder;
import com.alibaba.jstorm.utils.JStormUtils;
import com.codahale.metrics.Metered;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class JMeter
implements Metered {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toMillis(5L);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final LongAdder count = new LongAdder();
    private final long startTime = System.currentTimeMillis();
    private final AtomicLong lastTick = new AtomicLong(this.startTime);

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.count.add(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTimeMs = this.lastTick.get();
        long newTimeMs = System.currentTimeMillis();
        long age = newTimeMs - oldTimeMs;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTimeMs, newIntervalStartTick = newTimeMs - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m1Rate.tick();
                this.m5Rate.tick();
                this.m15Rate.tick();
            }
        }
    }

    public long getCount() {
        return this.count.sum();
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        double elapsed = System.currentTimeMillis() - this.startTime;
        return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toMillis(1L);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public static void main(String[] args) {
        int[] speeds = new int[]{0, 0, 0};
        JMeter jmeter = new JMeter();
        for (int i = 0; i < speeds.length; ++i) {
            for (int j = 0; j < 60; ++j) {
                JStormUtils.sleepMs(1000L);
            }
            jmeter.mark(973L);
            System.out.println(String.format("m1:%.2f, m5:%.2f, m15:%.2f, mean:%.2f", jmeter.getOneMinuteRate(), jmeter.getFiveMinuteRate(), jmeter.getFifteenMinuteRate(), jmeter.getMeanRate()));
        }
    }
}

