/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old;

import com.alibaba.jstorm.common.metric.old.operator.convert.Convertor;
import com.alibaba.jstorm.common.metric.old.operator.merger.AvgMerger;
import com.alibaba.jstorm.common.metric.old.operator.updater.AvgUpdater;
import com.alibaba.jstorm.common.metric.old.window.Metric;

public class Histogram
extends Metric<Double, HistorgramPair> {
    private static final long serialVersionUID = -1362345159511508074L;

    public Histogram() {
        this.defaultValue = new HistorgramPair();
        this.updater = new AvgUpdater();
        this.merger = new AvgMerger();
        this.convertor = new HistogramConvertor();
        this.init();
    }

    public static class HistorgramPair {
        private double sum;
        private long times;

        public HistorgramPair() {
        }

        public HistorgramPair(double sum, long times) {
            this.sum = sum;
            this.times = times;
        }

        public double getSum() {
            return this.sum;
        }

        public void setSum(double sum) {
            this.sum = sum;
        }

        public void addValue(double value) {
            this.sum += value;
        }

        public long getTimes() {
            return this.times;
        }

        public void setTimes(long times) {
            this.times = times;
        }

        public void addTimes(long time) {
            this.times += time;
        }
    }

    public static class HistogramConvertor
    implements Convertor<HistorgramPair, Double> {
        private static final long serialVersionUID = -1569170826785657226L;

        @Override
        public Double convert(HistorgramPair from) {
            if (from == null) {
                return 0.0;
            }
            if (from.getTimes() == 0L) {
                return 0.0;
            }
            return from.getSum() / (double)from.getTimes();
        }
    }
}

