/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old;

import com.alibaba.jstorm.common.metric.old.Histogram;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Timer
extends Histogram {
    private static final long serialVersionUID = 5915881891513771108L;

    public Timer() {
        this.init();
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toMillis(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(System.currentTimeMillis() - startTime);
        }
    }

    public Context time() {
        return new Context(this);
    }

    public long getCount() {
        return ((Histogram.HistorgramPair)this.allWindow.getSnapshot()).getTimes();
    }

    public static class Context
    implements Closeable {
        private final Timer timer;
        private final long startTime;

        private Context(Timer timer) {
            this.timer = timer;
            this.startTime = System.currentTimeMillis();
        }

        public long stop() {
            long elapsed = System.currentTimeMillis() - this.startTime;
            this.timer.update(elapsed, TimeUnit.MILLISECONDS);
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

