/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old;

import com.alibaba.jstorm.common.metric.old.operator.convert.Convertor;
import com.alibaba.jstorm.common.metric.old.operator.merger.Merger;
import com.alibaba.jstorm.common.metric.old.operator.updater.Updater;
import com.alibaba.jstorm.common.metric.old.window.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class Top<T>
extends Metric<List<T>, TreeSet<T>> {
    private static final long serialVersionUID = 4990212679365713831L;
    protected final Comparator<T> comparator;
    protected final int n;

    public Top(Comparator<T> comparator, int n) {
        this.comparator = comparator;
        this.n = n;
        this.defaultValue = new TreeSet<T>(comparator);
        this.updater = new TopUpdator<T>(comparator, n);
        this.merger = new TopMerger<T>(comparator, n);
        this.convertor = new SetToList();
        this.init();
    }

    public static class SetToList<T>
    implements Convertor<TreeSet<T>, List<T>> {
        private static final long serialVersionUID = 4968816655779625255L;

        @Override
        public List<T> convert(TreeSet<T> set) {
            ArrayList<T> ret = new ArrayList<T>();
            if (set != null) {
                for (T item : set) {
                    ret.add(item);
                }
            }
            return ret;
        }
    }

    public static class TopMerger<T>
    implements Merger<TreeSet<T>> {
        private static final long serialVersionUID = 4478867986986581638L;
        protected final Comparator<T> comparator;
        protected final int n;

        public TopMerger(Comparator<T> comparator, int n) {
            this.comparator = comparator;
            this.n = n;
        }

        @Override
        public TreeSet<T> merge(Collection<TreeSet<T>> objs, TreeSet<T> unflushed, Object ... others) {
            TreeSet<T> temp = new TreeSet<T>(this.comparator);
            if (unflushed != null) {
                temp.addAll(unflushed);
            }
            for (TreeSet<T> set : objs) {
                temp.addAll(set);
            }
            if (temp.size() <= this.n) {
                return temp;
            }
            TreeSet<T> ret = new TreeSet<T>(this.comparator);
            int i = 0;
            for (T item : temp) {
                if (i >= this.n) break;
                ret.add(item);
                ++i;
            }
            return ret;
        }
    }

    public static class TopUpdator<T>
    implements Updater<TreeSet<T>> {
        private static final long serialVersionUID = -3940041101182079146L;
        protected final Comparator<T> comparator;
        protected final int n;

        public TopUpdator(Comparator<T> comparator, int n) {
            this.comparator = comparator;
            this.n = n;
        }

        @Override
        public TreeSet<T> update(Number object, TreeSet<T> cache, Object ... others) {
            if (cache == null) {
                cache = new TreeSet<T>(this.comparator);
            }
            cache.add(object);
            if (cache.size() > this.n) {
                cache.remove(cache.last());
            }
            return cache;
        }

        @Override
        public TreeSet<T> updateBatch(TreeSet<T> object, TreeSet<T> cache, Object ... objects) {
            if (cache == null) {
                cache = new TreeSet<T>(this.comparator);
            }
            cache.addAll(object);
            while (cache.size() > this.n) {
                cache.remove(cache.last());
            }
            return cache;
        }
    }
}

