/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old.window;

import com.alibaba.jstorm.callback.Callback;
import com.alibaba.jstorm.common.metric.old.operator.Sampling;
import com.alibaba.jstorm.common.metric.old.operator.convert.Convertor;
import com.alibaba.jstorm.common.metric.old.operator.merger.Merger;
import com.alibaba.jstorm.common.metric.old.operator.updater.Updater;
import com.alibaba.jstorm.common.metric.old.window.AllWindow;
import com.alibaba.jstorm.common.metric.old.window.RollingWindow;
import com.alibaba.jstorm.common.metric.old.window.StatBuckets;
import com.alibaba.jstorm.utils.IntervalCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metric<T, V>
implements Sampling<Map<Integer, T>> {
    private static final long serialVersionUID = -1362345159511508074L;
    private static final Logger LOG = LoggerFactory.getLogger(Metric.class);
    protected static boolean enable;
    protected List<RollingWindow<V>> rollingWindows;
    protected AllWindow<V> allWindow;
    protected int[] windowSeconds = new int[]{StatBuckets.MINUTE_WINDOW, StatBuckets.HOUR_WINDOW, StatBuckets.DAY_WINDOW};
    protected int bucketSize = StatBuckets.NUM_STAT_BUCKETS;
    protected V defaultValue;
    protected Updater<V> updater;
    protected Merger<V> merger;
    protected Convertor<V, T> convertor;
    protected Callback callback;
    protected int interval;
    protected IntervalCheck intervalCheck;
    protected V unflushed;

    public static void setEnable(boolean e) {
        enable = e;
    }

    public int getInterval() {
        if (this.windowSeconds == null || this.windowSeconds.length == 0) {
            return StatBuckets.NUM_STAT_BUCKETS;
        }
        int[] intervals = new int[this.windowSeconds.length];
        int smallest = Integer.MAX_VALUE;
        for (int i = 0; i < this.windowSeconds.length; ++i) {
            int interval;
            intervals[i] = interval = this.windowSeconds[i] / this.bucketSize;
            if (interval >= smallest) continue;
            smallest = interval;
        }
        for (int goodInterval = smallest; goodInterval > 1; --goodInterval) {
            boolean good = true;
            for (int interval : intervals) {
                if (interval % goodInterval == 0) continue;
                good = false;
                break;
            }
            if (!good) continue;
            return goodInterval;
        }
        return 1;
    }

    public void init() {
        if (this.defaultValue == null || this.updater == null || this.merger == null || this.convertor == null) {
            throw new IllegalArgumentException("Invalid argements");
        }
        this.rollingWindows = new ArrayList<RollingWindow<V>>();
        if (this.windowSeconds != null) {
            this.rollingWindows.clear();
            for (int windowSize : this.windowSeconds) {
                RollingWindow<V> rollingWindow = new RollingWindow<V>(this.defaultValue, windowSize / this.bucketSize, windowSize, this.updater, this.merger);
                this.rollingWindows.add(rollingWindow);
            }
        }
        this.allWindow = new AllWindow<V>(this.defaultValue, this.updater, this.merger);
        this.interval = this.getInterval();
        this.intervalCheck = new IntervalCheck();
        this.intervalCheck.setInterval(this.interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Number obj) {
        if (!enable) {
            return;
        }
        if (this.intervalCheck.check()) {
            this.flush();
        }
        Metric metric = this;
        synchronized (metric) {
            this.unflushed = this.updater.update(obj, this.unflushed, new Object[0]);
        }
    }

    public synchronized void flush() {
        if (this.unflushed == null) {
            return;
        }
        for (RollingWindow<V> rollingWindow : this.rollingWindows) {
            rollingWindow.updateBatch(this.unflushed);
        }
        this.allWindow.updateBatch(this.unflushed);
        this.unflushed = null;
    }

    @Override
    public Map<Integer, T> getSnapshot() {
        this.flush();
        TreeMap<Integer, T> ret = new TreeMap<Integer, T>();
        for (RollingWindow<V> rollingWindow : this.rollingWindows) {
            V value = rollingWindow.getSnapshot();
            ret.put(rollingWindow.getWindowSecond(), this.convertor.convert(value));
        }
        ret.put(StatBuckets.ALL_TIME_WINDOW, this.convertor.convert(this.allWindow.getSnapshot()));
        if (this.callback != null) {
            this.callback.execute(this);
        }
        return ret;
    }

    public T getAllTimeValue() {
        return this.convertor.convert(this.allWindow.getSnapshot());
    }

    public int[] getWindowSeconds() {
        return this.windowSeconds;
    }

    public void setWindowSeconds(int[] windowSeconds) {
        this.windowSeconds = windowSeconds;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Updater<V> getUpdater() {
        return this.updater;
    }

    public void setUpdater(Updater<V> updater) {
        this.updater = updater;
    }

    public Merger<V> getMerger() {
        return this.merger;
    }

    public void setMerger(Merger<V> merger) {
        this.merger = merger;
    }

    public Convertor<V, T> getConvertor() {
        return this.convertor;
    }

    public void setConvertor(Convertor<V, T> convertor) {
        this.convertor = convertor;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }
}

