/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old.window;

import com.alibaba.jstorm.common.metric.old.operator.Sampling;
import com.alibaba.jstorm.common.metric.old.operator.StartTime;
import com.alibaba.jstorm.common.metric.old.operator.merger.Merger;
import com.alibaba.jstorm.common.metric.old.operator.updater.Updater;
import com.alibaba.jstorm.utils.IntervalCheck;
import com.alibaba.jstorm.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingWindow<V>
implements Sampling<V>,
StartTime {
    private static final long serialVersionUID = 3794478417380003279L;
    private static final Logger LOG = LoggerFactory.getLogger(RollingWindow.class);
    protected long startTime = System.currentTimeMillis();
    protected Integer currBucketTime;
    protected int interval;
    protected int windowSecond;
    protected IntervalCheck intervalCheck;
    protected TreeMap<Integer, V> buckets;
    protected Integer bucketNum;
    protected V unflushed;
    protected V defaultValue;
    protected Updater<V> updater;
    protected Merger<V> merger;

    RollingWindow(V defaultValue, int interval, int windowSecond, Updater<V> updater, Merger<V> merger) {
        this.interval = interval;
        this.intervalCheck = new IntervalCheck();
        this.intervalCheck.setInterval(interval);
        this.currBucketTime = this.getCurrBucketTime();
        this.bucketNum = windowSecond / interval;
        this.windowSecond = this.bucketNum * interval;
        this.buckets = new TreeMap();
        this.updater = updater;
        this.merger = merger;
        this.defaultValue = defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Number obj) {
        if (this.intervalCheck.check()) {
            this.rolling();
        }
        RollingWindow rollingWindow = this;
        synchronized (rollingWindow) {
            this.unflushed = this.updater.update(obj, this.unflushed, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBatch(V batch) {
        if (this.intervalCheck.check()) {
            this.rolling();
        }
        RollingWindow rollingWindow = this;
        synchronized (rollingWindow) {
            this.unflushed = this.updater.updateBatch(batch, this.unflushed, new Object[0]);
        }
    }

    @Override
    public V getSnapshot() {
        if (this.intervalCheck.check()) {
            this.rolling();
        }
        this.cleanExpiredBuckets();
        Collection<V> values = this.buckets.values();
        V ret = this.merger.merge(values, this.unflushed, this);
        if (ret == null) {
            return this.defaultValue;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rolling() {
        RollingWindow rollingWindow = this;
        synchronized (rollingWindow) {
            if (this.unflushed != null) {
                this.buckets.put(this.currBucketTime, this.unflushed);
                this.unflushed = null;
            }
            this.currBucketTime = this.getCurrBucketTime();
            return;
        }
    }

    protected void cleanExpiredBuckets() {
        int nowSec = TimeUtils.current_time_secs();
        int startRemove = nowSec - (this.interval - 1) - this.windowSecond;
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (Integer keyTime : this.buckets.keySet()) {
            if (keyTime < startRemove) {
                removeList.add(keyTime);
                continue;
            }
            if (keyTime < startRemove) continue;
            break;
        }
        for (Integer removeKey : removeList) {
            this.buckets.remove(removeKey);
        }
        if (!this.buckets.isEmpty()) {
            Integer first = this.buckets.firstKey();
            this.startTime = first.longValue() * 1000L;
        }
    }

    public int getWindowSecond() {
        return this.windowSecond;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public int getInterval() {
        return this.interval;
    }

    public Integer getBucketNum() {
        return this.bucketNum;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    private Integer getCurrBucketTime() {
        return TimeUtils.current_time_secs() / this.interval * this.interval;
    }
}

