/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric.old.window;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class StatBuckets {
    public static final Integer NUM_STAT_BUCKETS = 20;
    public static final Integer MINUTE_WINDOW = 600;
    public static final Integer HOUR_WINDOW = 10800;
    public static final Integer DAY_WINDOW = 86400;
    public static final Integer ALL_TIME_WINDOW = 0;
    public static Set<Integer> TIME_WINDOWS = new TreeSet<Integer>();
    public static final String MINUTE_WINDOW_STR = "0d0h10m0s";
    public static final String HOUR_WINDOW_STR = "0d3h0m0s";
    public static final String DAY_WINDOW_STR = "1d0h0m0s";
    public static final String ALL_WINDOW_STR = "All-time";
    public static Integer[] STAT_BUCKETS;
    private static final String[][] PRETTYSECDIVIDERS;

    public static String parseTimeKey(Integer key) {
        if (key == 0) {
            return ALL_WINDOW_STR;
        }
        return String.valueOf(key);
    }

    public static Integer getTimeKey(String showKey) {
        Integer window = null;
        window = showKey == null ? MINUTE_WINDOW : (showKey.equals(MINUTE_WINDOW_STR) ? MINUTE_WINDOW : (showKey.equals(HOUR_WINDOW_STR) ? HOUR_WINDOW : (showKey.equals(DAY_WINDOW_STR) ? DAY_WINDOW : (showKey.equals(ALL_WINDOW_STR) ? ALL_TIME_WINDOW : MINUTE_WINDOW))));
        return window;
    }

    public static String getShowTimeStr(Integer time) {
        if (time == null) {
            return MINUTE_WINDOW_STR;
        }
        if (time.equals(MINUTE_WINDOW)) {
            return MINUTE_WINDOW_STR;
        }
        if (time.equals(HOUR_WINDOW)) {
            return HOUR_WINDOW_STR;
        }
        if (time.equals(DAY_WINDOW)) {
            return DAY_WINDOW_STR;
        }
        if (time.equals(ALL_TIME_WINDOW)) {
            return ALL_WINDOW_STR;
        }
        return MINUTE_WINDOW_STR;
    }

    public static String prettyUptimeStr(int secs) {
        int diversize = PRETTYSECDIVIDERS.length;
        ArrayList<String> tmp = new ArrayList<String>();
        int div = secs;
        for (int i = 0; i < diversize; ++i) {
            if (PRETTYSECDIVIDERS[i][1] != null) {
                Integer d = Integer.parseInt(PRETTYSECDIVIDERS[i][1]);
                tmp.add(div % d + PRETTYSECDIVIDERS[i][0]);
                div /= d.intValue();
                continue;
            }
            tmp.add(div + PRETTYSECDIVIDERS[i][0]);
        }
        String rtn = "";
        int tmpSzie = tmp.size();
        for (int j = tmpSzie - 1; j > -1; --j) {
            rtn = rtn + (String)tmp.get(j);
        }
        return rtn;
    }

    public static void main(String[] args) {
    }

    static {
        TIME_WINDOWS.add(ALL_TIME_WINDOW);
        TIME_WINDOWS.add(MINUTE_WINDOW);
        TIME_WINDOWS.add(HOUR_WINDOW);
        TIME_WINDOWS.add(DAY_WINDOW);
        STAT_BUCKETS = new Integer[]{MINUTE_WINDOW / NUM_STAT_BUCKETS, HOUR_WINDOW / NUM_STAT_BUCKETS, DAY_WINDOW / NUM_STAT_BUCKETS};
        PRETTYSECDIVIDERS = new String[][]{{"s", "60"}, {"m", "60"}, {"h", "24"}, {"d", null}};
    }
}

