/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.container;

import com.alibaba.jstorm.container.CgroupOperation;
import com.alibaba.jstorm.container.CgroupUtils;
import com.alibaba.jstorm.container.Hierarchy;
import com.alibaba.jstorm.container.SubSystem;
import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.container.cgroup.CgroupCommon;
import com.alibaba.jstorm.utils.SystemOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupCenter
implements CgroupOperation {
    public static Logger LOG = LoggerFactory.getLogger(CgroupCenter.class);
    private static CgroupCenter instance;

    private CgroupCenter() {
    }

    public static synchronized CgroupCenter getInstance() {
        if (instance == null) {
            instance = new CgroupCenter();
        }
        return CgroupUtils.enabled() ? instance : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Hierarchy> getHierarchies() {
        ArrayList<Hierarchy> arrayList;
        HashMap<String, Hierarchy> hierarchies = new HashMap<String, Hierarchy>();
        FileReader reader = null;
        BufferedReader br = null;
        try {
            reader = new FileReader("/proc/mounts");
            br = new BufferedReader(reader);
            String str = null;
            while ((str = br.readLine()) != null) {
                String[] strSplit = str.split(" ");
                if (!strSplit[2].equals("cgroup")) continue;
                String name = strSplit[0];
                String type = strSplit[3];
                String dir = strSplit[1];
                Hierarchy h = (Hierarchy)hierarchies.get(type);
                h = new Hierarchy(name, CgroupUtils.analyse(type), dir);
                hierarchies.put(type, h);
            }
            arrayList = new ArrayList<Hierarchy>(hierarchies.values());
        }
        catch (Exception e) {
            try {
                LOG.error("Get hierarchies error", (Throwable)e);
            }
            catch (Throwable throwable) {
                CgroupUtils.close(reader, br);
                throw throwable;
            }
            CgroupUtils.close(reader, br);
            return null;
        }
        CgroupUtils.close(reader, br);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<SubSystem> getSubSystems() {
        HashSet<SubSystem> hashSet;
        HashSet<SubSystem> subSystems = new HashSet<SubSystem>();
        FileReader reader = null;
        BufferedReader br = null;
        try {
            reader = new FileReader("/proc/cgroups");
            br = new BufferedReader(reader);
            String str = null;
            while ((str = br.readLine()) != null) {
                String[] split = str.split("\t");
                SubSystemType type = SubSystemType.getSubSystem(split[0]);
                if (type == null) continue;
                subSystems.add(new SubSystem(type, Integer.valueOf(split[1]), Integer.valueOf(split[2]), Integer.valueOf(split[3]) == 1));
            }
            hashSet = subSystems;
        }
        catch (Exception e) {
            try {
                LOG.error("Get subSystems error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                CgroupUtils.close(reader, br);
                throw throwable;
            }
            CgroupUtils.close(reader, br);
            return null;
        }
        CgroupUtils.close(reader, br);
        return hashSet;
    }

    @Override
    public boolean enabled(SubSystemType subsystem) {
        Set<SubSystem> subSystems = this.getSubSystems();
        for (SubSystem subSystem : subSystems) {
            if (subSystem.getType() != subsystem) continue;
            return true;
        }
        return false;
    }

    @Override
    public Hierarchy busy(SubSystemType subsystem) {
        List<Hierarchy> hierarchies = this.getHierarchies();
        for (Hierarchy hierarchy : hierarchies) {
            for (SubSystemType type : hierarchy.getSubSystems()) {
                if (type != subsystem) continue;
                return hierarchy;
            }
        }
        return null;
    }

    @Override
    public Hierarchy mounted(Hierarchy hierarchy) {
        List<Hierarchy> hierarchies = this.getHierarchies();
        if (CgroupUtils.dirExists(hierarchy.getDir())) {
            for (Hierarchy h : hierarchies) {
                if (!h.equals(hierarchy)) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public void mount(Hierarchy hierarchy) throws IOException {
        if (this.mounted(hierarchy) != null) {
            LOG.error(hierarchy.getDir() + " is mounted");
            return;
        }
        Set<SubSystemType> subsystems = hierarchy.getSubSystems();
        for (SubSystemType type : subsystems) {
            if (this.busy(type) == null) continue;
            LOG.error("subsystem: " + type.name() + " is busy");
            subsystems.remove((Object)type);
        }
        if (subsystems.size() == 0) {
            return;
        }
        if (!CgroupUtils.dirExists(hierarchy.getDir())) {
            new File(hierarchy.getDir()).mkdirs();
        }
        String subSystems = CgroupUtils.reAnalyse(subsystems);
        SystemOperation.mount(subSystems, hierarchy.getDir(), "cgroup", subSystems);
    }

    @Override
    public void umount(Hierarchy hierarchy) throws IOException {
        if (this.mounted(hierarchy) != null) {
            hierarchy.getRootCgroups().delete();
            SystemOperation.umount(hierarchy.getDir());
            CgroupUtils.deleteDir(hierarchy.getDir());
        }
    }

    @Override
    public void create(CgroupCommon cgroup) throws SecurityException {
        if (cgroup.isRoot()) {
            LOG.error("You can't create rootCgroup in this function");
            return;
        }
        for (CgroupCommon parent = cgroup.getParent(); parent != null; parent = parent.getParent()) {
            if (CgroupUtils.dirExists(parent.getDir())) continue;
            LOG.error(parent.getDir() + "is not existed");
            return;
        }
        Hierarchy h = cgroup.getHierarchy();
        if (this.mounted(h) == null) {
            LOG.error(h.getDir() + " is not mounted");
            return;
        }
        if (CgroupUtils.dirExists(cgroup.getDir())) {
            LOG.error(cgroup.getDir() + " is existed");
            return;
        }
        new File(cgroup.getDir()).mkdir();
    }

    @Override
    public void delete(CgroupCommon cgroup) throws IOException {
        cgroup.delete();
    }

    public static void main(String[] args) {
        System.out.println(CgroupCenter.getInstance().getHierarchies().get(0).getRootCgroups().getChildren().size());
    }
}

