/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.container;

import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.utils.SystemOperation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupUtils {
    public static final Logger LOG = LoggerFactory.getLogger(CgroupUtils.class);

    public static void deleteDir(String dir) {
        try {
            String cmd = "rmdir " + dir;
            SystemOperation.exec(cmd);
        }
        catch (IOException e) {
            LOG.error("rm " + dir + " fail!", (Throwable)e);
        }
    }

    public static boolean fileExists(String dir) {
        File file = new File(dir);
        return file.exists();
    }

    public static boolean dirExists(String dir) {
        File file = new File(dir);
        return file.isDirectory();
    }

    public static Set<SubSystemType> analyse(String str) {
        String[] subSystems;
        HashSet<SubSystemType> result2 = new HashSet<SubSystemType>();
        for (String subSystem : subSystems = str.split(",")) {
            SubSystemType type = SubSystemType.getSubSystem(subSystem);
            if (type == null) continue;
            result2.add(type);
        }
        return result2;
    }

    public static String reAnalyse(Set<SubSystemType> subSystems) {
        StringBuilder sb = new StringBuilder();
        if (subSystems.size() == 0) {
            return sb.toString();
        }
        for (SubSystemType type : subSystems) {
            sb.append(type.name()).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static boolean enabled() {
        return CgroupUtils.fileExists("/proc/cgroups");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileByLine(String fileDir) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            File file = new File(fileDir);
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                result2.add(tempString);
            }
        }
        catch (Throwable throwable) {
            CgroupUtils.close(fileReader, reader);
            throw throwable;
        }
        CgroupUtils.close(fileReader, reader);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileByLine(String fileDir, List<String> strings) throws IOException {
        File file;
        BufferedWriter bw;
        FileWriter writer;
        block4: {
            writer = null;
            bw = null;
            file = new File(fileDir);
            if (file.exists()) break block4;
            LOG.error(fileDir + " is no existed");
            CgroupUtils.close(writer, bw);
            return;
        }
        try {
            writer = new FileWriter(file, true);
            bw = new BufferedWriter(writer);
            for (String string : strings) {
                bw.write(string);
                bw.newLine();
                bw.flush();
            }
        }
        catch (Throwable throwable) {
            CgroupUtils.close(writer, bw);
            throw throwable;
        }
        CgroupUtils.close(writer, bw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileByLine(String fileDir, String string) throws IOException {
        File file;
        BufferedWriter bw;
        FileWriter writer;
        block3: {
            writer = null;
            bw = null;
            try {
                file = new File(fileDir);
                if (file.exists()) break block3;
                LOG.error(fileDir + " is no existed");
            }
            catch (Throwable throwable) {
                CgroupUtils.close(writer, bw);
                throw throwable;
            }
            CgroupUtils.close(writer, bw);
            return;
        }
        writer = new FileWriter(file, true);
        bw = new BufferedWriter(writer);
        bw.write(string);
        bw.newLine();
        bw.flush();
        CgroupUtils.close(writer, bw);
    }

    public static void close(FileReader reader, BufferedReader br) {
        try {
            if (reader != null) {
                reader.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(FileWriter writer, BufferedWriter bw) {
        try {
            if (writer != null) {
                writer.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void sleep(long s) {
        try {
            Thread.sleep(s);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

