/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.container;

import com.alibaba.jstorm.container.CgroupUtils;
import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.container.cgroup.CgroupCommon;
import java.util.Set;

public class Hierarchy {
    private final String name;
    private final Set<SubSystemType> subSystems;
    private final String type;
    private final String dir;
    private final CgroupCommon rootCgroups;

    public Hierarchy(String name, Set<SubSystemType> subSystems, String dir) {
        this.name = name;
        this.subSystems = subSystems;
        this.dir = dir;
        this.rootCgroups = new CgroupCommon(this, dir);
        this.type = CgroupUtils.reAnalyse(subSystems);
    }

    public Set<SubSystemType> getSubSystems() {
        return this.subSystems;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.dir == null ? 0 : this.dir.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hierarchy other = (Hierarchy)obj;
        if (this.dir == null ? other.dir != null : !this.dir.equals(other.dir)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getDir() {
        return this.dir;
    }

    public CgroupCommon getRootCgroups() {
        return this.rootCgroups;
    }

    public String getName() {
        return this.name;
    }

    public boolean subSystemMounted(SubSystemType subsystem) {
        for (SubSystemType type : this.subSystems) {
            if (type != subsystem) continue;
            return true;
        }
        return false;
    }
}

