/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.container.cgroup;

import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.container.cgroup.core.BlkioCore;
import com.alibaba.jstorm.container.cgroup.core.CgroupCore;
import com.alibaba.jstorm.container.cgroup.core.CpuCore;
import com.alibaba.jstorm.container.cgroup.core.CpuacctCore;
import com.alibaba.jstorm.container.cgroup.core.CpusetCore;
import com.alibaba.jstorm.container.cgroup.core.DevicesCore;
import com.alibaba.jstorm.container.cgroup.core.FreezerCore;
import com.alibaba.jstorm.container.cgroup.core.MemoryCore;
import com.alibaba.jstorm.container.cgroup.core.NetClsCore;
import com.alibaba.jstorm.container.cgroup.core.NetPrioCore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CgroupCoreFactory {
    public static Map<SubSystemType, CgroupCore> getInstance(Set<SubSystemType> types, String dir) {
        HashMap<SubSystemType, CgroupCore> result2 = new HashMap<SubSystemType, CgroupCore>();
        for (SubSystemType type : types) {
            switch (type) {
                case blkio: {
                    result2.put(SubSystemType.blkio, new BlkioCore(dir));
                    break;
                }
                case cpuacct: {
                    result2.put(SubSystemType.cpuacct, new CpuacctCore(dir));
                    break;
                }
                case cpuset: {
                    result2.put(SubSystemType.cpuset, new CpusetCore(dir));
                    break;
                }
                case cpu: {
                    result2.put(SubSystemType.cpu, new CpuCore(dir));
                    break;
                }
                case devices: {
                    result2.put(SubSystemType.devices, new DevicesCore(dir));
                    break;
                }
                case freezer: {
                    result2.put(SubSystemType.freezer, new FreezerCore(dir));
                    break;
                }
                case memory: {
                    result2.put(SubSystemType.memory, new MemoryCore(dir));
                    break;
                }
                case net_cls: {
                    result2.put(SubSystemType.net_cls, new NetClsCore(dir));
                    break;
                }
                case net_prio: {
                    result2.put(SubSystemType.net_prio, new NetPrioCore(dir));
                    break;
                }
            }
        }
        return result2;
    }
}

