/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.container.cgroup.core;

import com.alibaba.jstorm.container.CgroupUtils;
import com.alibaba.jstorm.container.Constants;
import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.container.cgroup.core.CgroupCore;
import java.io.IOException;

public class FreezerCore
implements CgroupCore {
    public static final String FREEZER_STATE = "/freezer.state";
    private final String dir;

    public FreezerCore(String dir) {
        this.dir = dir;
    }

    @Override
    public SubSystemType getType() {
        return SubSystemType.freezer;
    }

    public void setState(State state) throws IOException {
        CgroupUtils.writeFileByLine(Constants.getDir(this.dir, FREEZER_STATE), state.name().toUpperCase());
    }

    public State getState() throws IOException {
        return State.getStateValue(CgroupUtils.readFileByLine(Constants.getDir(this.dir, FREEZER_STATE)).get(0));
    }

    public static enum State {
        frozen,
        freezing,
        thawed;


        public static State getStateValue(String state) {
            if (state.equals("FROZEN")) {
                return frozen;
            }
            if (state.equals("FREEZING")) {
                return freezing;
            }
            if (state.equals("THAWED")) {
                return thawed;
            }
            return null;
        }
    }
}

