/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.nimbus;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cache.JStormCache;
import com.alibaba.jstorm.cache.RocksDBCache;
import com.alibaba.jstorm.cache.TimeoutMemCache;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.utils.OSInfo;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusCache {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusCache.class);
    public static final String TIMEOUT_MEM_CACHE_CLASS = TimeoutMemCache.class.getName();
    public static final String ROCKS_DB_CACHE_CLASS = RocksDBCache.class.getName();
    protected JStormCache memCache;
    protected JStormCache dbCache;
    protected StormClusterState zkCluster;

    public String getNimbusCacheClass(Map conf) {
        boolean isLinux = OSInfo.isLinux();
        boolean isMac = OSInfo.isMac();
        boolean isLocal = StormConfig.local_mode(conf);
        if (isLocal) {
            return TIMEOUT_MEM_CACHE_CLASS;
        }
        if (!isLinux && !isMac) {
            return TIMEOUT_MEM_CACHE_CLASS;
        }
        String nimbusCacheClass = ConfigExtension.getNimbusCacheClass(conf);
        if (!StringUtils.isBlank((String)nimbusCacheClass)) {
            return nimbusCacheClass;
        }
        return ROCKS_DB_CACHE_CLASS;
    }

    public NimbusCache(Map conf, StormClusterState zkCluster) {
        String dbCacheClass = this.getNimbusCacheClass(conf);
        LOG.info("NimbusCache db Cache will use {}", (Object)dbCacheClass);
        try {
            this.dbCache = (JStormCache)Utils.newInstance(dbCacheClass);
            String dbDir = StormConfig.masterDbDir(conf);
            conf.put("rocksdb.root.dir", dbDir);
            conf.put("rocksdb.reset", ConfigExtension.getNimbusCacheReset(conf));
            this.dbCache.init(conf);
            if (this.dbCache instanceof TimeoutMemCache) {
                this.memCache = this.dbCache;
            } else {
                this.memCache = new TimeoutMemCache();
                this.memCache.init(conf);
            }
        }
        catch (UnsupportedClassVersionError e) {
            if (e.getMessage().indexOf("Unsupported major.minor version") >= 0) {
                LOG.error("!!!Please update jdk version to 7 or higher!!!");
            }
            LOG.error("Failed to create NimbusCache!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error("Failed to create NimbusCache!", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.zkCluster = zkCluster;
    }

    public JStormCache getMemCache() {
        return this.memCache;
    }

    public JStormCache getDbCache() {
        return this.dbCache;
    }

    public void cleanup() {
        this.dbCache.cleanup();
    }
}

