/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.nimbus;

import com.alibaba.jstorm.callback.BaseCallback;
import com.alibaba.jstorm.callback.Callback;
import com.alibaba.jstorm.callback.impl.ActiveTransitionCallback;
import com.alibaba.jstorm.callback.impl.DoRebalanceTransitionCallback;
import com.alibaba.jstorm.callback.impl.DoneRebalanceTransitionCallback;
import com.alibaba.jstorm.callback.impl.InactiveTransitionCallback;
import com.alibaba.jstorm.callback.impl.KillTransitionCallback;
import com.alibaba.jstorm.callback.impl.ReassignTransitionCallback;
import com.alibaba.jstorm.callback.impl.RebalanceTransitionCallback;
import com.alibaba.jstorm.callback.impl.RemoveTransitionCallback;
import com.alibaba.jstorm.callback.impl.UpdateTopologyTransitionCallback;
import com.alibaba.jstorm.cluster.StormBase;
import com.alibaba.jstorm.cluster.StormStatus;
import com.alibaba.jstorm.daemon.nimbus.NimbusData;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusTransition {
    private static final Logger LOG = LoggerFactory.getLogger(StatusTransition.class);
    private NimbusData data;
    private Map<String, Object> topologyLocks = new ConcurrentHashMap<String, Object>();

    public StatusTransition(NimbusData data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void transition(String topologyid, boolean errorOnNoTransition, StatusType changeStatus, T ... args) throws Exception {
        Object lock = this.topologyLocks.get(topologyid);
        if (lock == null) {
            lock = new Object();
            this.topologyLocks.put(topologyid, lock);
        }
        if (this.data.getIsShutdown().get()) {
            LOG.info("Nimbus is in shutdown, skip this event " + topologyid + ":" + (Object)((Object)changeStatus));
            return;
        }
        Object object = lock;
        synchronized (object) {
            this.transitionLock(topologyid, errorOnNoTransition, changeStatus, args);
            this.topologyLocks.put(topologyid, lock);
        }
    }

    public <T> void transitionLock(String topologyid, boolean errorOnNoTransition, StatusType changeStatus, T ... args) throws Exception {
        StormBase stormbase = this.data.getStormClusterState().storm_base(topologyid, null);
        if (stormbase == null) {
            LOG.error("Cannot apply event changing status " + changeStatus.getStatus() + " to " + topologyid + " because failed to get StormBase from ZK");
            return;
        }
        StormStatus currentStatus = stormbase.getStatus();
        if (currentStatus == null) {
            LOG.error("Cannot apply event changing status " + changeStatus.getStatus() + " to " + topologyid + " because topologyStatus is null in ZK");
            return;
        }
        Map<StatusType, Map<StatusType, Callback>> callbackMap = this.stateTransitions(topologyid, currentStatus);
        Map<StatusType, Callback> changingCallbacks = callbackMap.get((Object)currentStatus.getStatusType());
        if (changingCallbacks == null || !changingCallbacks.containsKey((Object)changeStatus) || changingCallbacks.get((Object)changeStatus) == null) {
            String msg = "No transition for event: changing status:" + changeStatus.getStatus() + ", current status: " + (Object)((Object)currentStatus.getStatusType()) + " topology-id: " + topologyid;
            LOG.info(msg);
            if (errorOnNoTransition) {
                throw new RuntimeException(msg);
            }
            return;
        }
        Callback callback = changingCallbacks.get((Object)changeStatus);
        Object obj = callback.execute(args);
        if (obj != null && obj instanceof StormStatus) {
            StormStatus newStatus = (StormStatus)obj;
            this.data.getStormClusterState().update_storm(topologyid, newStatus);
            LOG.info("Successfully updated " + topologyid + " as status " + newStatus);
        }
        LOG.info("Successfully apply event changing status " + changeStatus.getStatus() + " to " + topologyid);
    }

    private Map<StatusType, Map<StatusType, Callback>> stateTransitions(String topologyid, StormStatus currentStatus) {
        HashMap<StatusType, Map<StatusType, Callback>> rtn = new HashMap<StatusType, Map<StatusType, Callback>>();
        HashMap<StatusType, BaseCallback> activeMap = new HashMap<StatusType, BaseCallback>();
        activeMap.put(StatusType.monitor, new ReassignTransitionCallback(this.data, topologyid));
        activeMap.put(StatusType.inactivate, new InactiveTransitionCallback());
        activeMap.put(StatusType.startup, null);
        activeMap.put(StatusType.activate, null);
        activeMap.put(StatusType.kill, new KillTransitionCallback(this.data, topologyid));
        activeMap.put(StatusType.remove, null);
        activeMap.put(StatusType.rebalance, new RebalanceTransitionCallback(this.data, topologyid, currentStatus));
        activeMap.put(StatusType.do_rebalance, null);
        activeMap.put(StatusType.done_rebalance, null);
        activeMap.put(StatusType.update_topology, new UpdateTopologyTransitionCallback(this.data, topologyid, currentStatus));
        rtn.put(StatusType.active, activeMap);
        HashMap<StatusType, BaseCallback> inactiveMap = new HashMap<StatusType, BaseCallback>();
        inactiveMap.put(StatusType.monitor, new ReassignTransitionCallback(this.data, topologyid, new StormStatus(StatusType.inactive)));
        inactiveMap.put(StatusType.inactivate, null);
        inactiveMap.put(StatusType.startup, null);
        inactiveMap.put(StatusType.activate, new ActiveTransitionCallback());
        inactiveMap.put(StatusType.kill, new KillTransitionCallback(this.data, topologyid));
        inactiveMap.put(StatusType.remove, null);
        inactiveMap.put(StatusType.rebalance, new RebalanceTransitionCallback(this.data, topologyid, currentStatus));
        inactiveMap.put(StatusType.do_rebalance, null);
        inactiveMap.put(StatusType.done_rebalance, null);
        inactiveMap.put(StatusType.update_topology, null);
        rtn.put(StatusType.inactive, inactiveMap);
        HashMap<StatusType, BaseCallback> killedMap = new HashMap<StatusType, BaseCallback>();
        killedMap.put(StatusType.monitor, null);
        killedMap.put(StatusType.inactivate, null);
        killedMap.put(StatusType.startup, new KillTransitionCallback(this.data, topologyid));
        killedMap.put(StatusType.activate, null);
        killedMap.put(StatusType.kill, new KillTransitionCallback(this.data, topologyid));
        killedMap.put(StatusType.remove, new RemoveTransitionCallback(this.data, topologyid));
        killedMap.put(StatusType.rebalance, null);
        killedMap.put(StatusType.do_rebalance, null);
        killedMap.put(StatusType.done_rebalance, null);
        killedMap.put(StatusType.update_topology, null);
        rtn.put(StatusType.killed, killedMap);
        HashMap<StatusType, BaseCallback> rebalancingMap = new HashMap<StatusType, BaseCallback>();
        StatusType rebalanceOldStatus = StatusType.active;
        if (currentStatus.getOldStatus() != null && (rebalanceOldStatus = currentStatus.getOldStatus().getStatusType()) == StatusType.rebalancing) {
            rebalanceOldStatus = StatusType.active;
        }
        rebalancingMap.put(StatusType.monitor, null);
        rebalancingMap.put(StatusType.inactivate, null);
        rebalancingMap.put(StatusType.startup, new RebalanceTransitionCallback(this.data, topologyid, new StormStatus(rebalanceOldStatus)));
        rebalancingMap.put(StatusType.activate, null);
        rebalancingMap.put(StatusType.kill, null);
        rebalancingMap.put(StatusType.remove, null);
        rebalancingMap.put(StatusType.rebalance, new RebalanceTransitionCallback(this.data, topologyid, currentStatus));
        rebalancingMap.put(StatusType.do_rebalance, new DoRebalanceTransitionCallback(this.data, topologyid, new StormStatus(rebalanceOldStatus)));
        rebalancingMap.put(StatusType.done_rebalance, new DoneRebalanceTransitionCallback(this.data, topologyid));
        rebalancingMap.put(StatusType.update_topology, null);
        rtn.put(StatusType.rebalancing, rebalancingMap);
        return rtn;
    }
}

