/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.nimbus;

import com.alibaba.jstorm.cluster.StormStatus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TopologyAssignEvent {
    private static final int DEFAULT_WAIT_TIME = 5;
    private String topologyId;
    private String topologyName;
    private String group;
    private boolean isScratch;
    private boolean isReassign;
    private StormStatus oldStatus;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean isSuccess = false;
    private String errorMsg;
    private boolean isScaleTopology = false;

    public void setScaleTopology(boolean isScaleTopology) {
        this.isScaleTopology = isScaleTopology;
    }

    public boolean isScaleTopology() {
        return this.isScaleTopology;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public boolean isScratch() {
        return this.isScratch;
    }

    public void setScratch(boolean isScratch) {
        this.isScratch = isScratch;
    }

    public boolean isReassign() {
        return this.isReassign;
    }

    public void setReassign(boolean isReassign) {
        this.isReassign = isReassign;
    }

    public StormStatus getOldStatus() {
        return this.oldStatus;
    }

    public void setOldStatus(StormStatus oldStatus) {
        this.oldStatus = oldStatus;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public boolean waitFinish() {
        try {
            this.latch.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.isSuccess;
    }

    public boolean isFinish() {
        return this.latch.getCount() == 0L;
    }

    public void done() {
        this.isSuccess = true;
        this.latch.countDown();
    }

    public void fail(String errorMsg) {
        this.isSuccess = false;
        this.errorMsg = errorMsg;
        this.latch.countDown();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

