/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.nimbus;

import backtype.storm.generated.InvalidTopologyException;
import com.alibaba.jstorm.cluster.Common;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.metric.MetricUtils;
import java.util.Map;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyNettyMgr {
    private static Logger LOG = LoggerFactory.getLogger(TopologyNettyMgr.class);
    private Map nimbusConf;
    private ConcurrentHashMap<String, Boolean> setting = new ConcurrentHashMap();

    public TopologyNettyMgr(Map conf) {
        this.nimbusConf = conf;
    }

    protected boolean getTopology(Map conf) {
        return MetricUtils.isEnableNettyMetrics(conf);
    }

    public boolean getTopology(String topologyId) {
        try {
            String topologyName = Common.topologyIdToName(topologyId);
            Boolean isEnable = (Boolean)this.setting.get((Object)topologyName);
            if (isEnable != null) {
                return isEnable;
            }
            Map topologyConf = StormConfig.read_nimbus_topology_conf(this.nimbusConf, topologyId);
            isEnable = this.getTopology(topologyConf);
            this.setting.put((Object)topologyName, (Object)isEnable);
            LOG.info("{} netty metrics setting is {}", (Object)topologyName, (Object)isEnable);
            return isEnable;
        }
        catch (Exception e) {
            LOG.info("Failed to get {} netty metrics setting ", (Object)topologyId);
            return true;
        }
    }

    public void setTopology(Map conf) {
        String topologyName = (String)conf.get("topology.name");
        if (topologyName == null) {
            LOG.info("No topologyName setting");
            return;
        }
        boolean isEnable = this.getTopology(conf);
        this.setting.put((Object)topologyName, (Object)isEnable);
        LOG.info("{} netty metrics setting is {}", (Object)topologyName, (Object)isEnable);
    }

    public void rmTopology(String topologyId) {
        try {
            String topologyName = Common.topologyIdToName(topologyId);
            this.setting.remove((Object)topologyName);
            LOG.info("Remove {} netty metrics setting ", (Object)topologyName);
        }
        catch (InvalidTopologyException invalidTopologyException) {
            // empty catch block
        }
    }
}

