/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.container.CgroupCenter;
import com.alibaba.jstorm.container.Hierarchy;
import com.alibaba.jstorm.container.SubSystemType;
import com.alibaba.jstorm.container.cgroup.CgroupCommon;
import com.alibaba.jstorm.container.cgroup.core.CgroupCore;
import com.alibaba.jstorm.container.cgroup.core.CpuCore;
import com.alibaba.jstorm.utils.JStormUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupManager {
    public static final Logger LOG = LoggerFactory.getLogger(CgroupManager.class);
    public static final String JSTORM_HIERARCHY_NAME = "jstorm_cpu";
    public static final int ONE_CPU_SLOT = 1024;
    private CgroupCenter center;
    private Hierarchy h;
    private CgroupCommon rootCgroup;
    private static final String JSTORM_CPU_HIERARCHY_DIR = "/cgroup/cpu";
    private static String rootDir;

    public CgroupManager(Map conf) {
        LOG.info("running on cgroup mode");
        rootDir = ConfigExtension.getCgroupRootDir(conf);
        if (rootDir == null) {
            throw new RuntimeException("Check configuration file. The supervisor.cgroup.rootdir is missing.");
        }
        File file = new File("/cgroup/cpu/" + rootDir);
        if (!file.exists()) {
            LOG.error("/cgroup/cpu/" + rootDir + " is not existing.");
            throw new RuntimeException("Check if cgconfig service starts or /etc/cgconfig.conf is consistent with configuration file.");
        }
        this.center = CgroupCenter.getInstance();
        if (this.center == null) {
            throw new RuntimeException("Cgroup error, please check /proc/cgroups");
        }
        this.prepareSubSystem();
    }

    private int validateCpuUpperLimitValue(int value) {
        if (value > 10) {
            value = 10;
        } else if (value < 1 && value != -1) {
            value = 1;
        }
        return value;
    }

    private void setCpuUsageUpperLimit(CpuCore cpuCore, int cpuCoreUpperLimit) throws IOException {
        if ((cpuCoreUpperLimit = this.validateCpuUpperLimitValue(cpuCoreUpperLimit)) == -1) {
            cpuCore.setCpuCfsQuotaUs(cpuCoreUpperLimit);
        } else {
            cpuCore.setCpuCfsPeriodUs(100000L);
            cpuCore.setCpuCfsQuotaUs(cpuCoreUpperLimit * 100000);
        }
    }

    public String startNewWorker(Map conf, int cpuNum, String workerId) throws SecurityException, IOException {
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.h, this.rootCgroup);
        this.center.create(workerGroup);
        CgroupCore cpu = workerGroup.getCores().get((Object)SubSystemType.cpu);
        CpuCore cpuCore = (CpuCore)cpu;
        cpuCore.setCpuShares(cpuNum * 1024);
        this.setCpuUsageUpperLimit(cpuCore, ConfigExtension.getWorkerCpuCoreUpperLimit(conf));
        StringBuilder sb = new StringBuilder();
        sb.append("cgexec -g cpu:").append(workerGroup.getName()).append(" ");
        return sb.toString();
    }

    public void shutDownWorker(String workerId, boolean isKilled) {
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.h, this.rootCgroup);
        try {
            if (!isKilled) {
                for (Integer pid : workerGroup.getTasks()) {
                    JStormUtils.kill(pid);
                }
                JStormUtils.sleepMs(1500L);
            }
            this.center.delete(workerGroup);
        }
        catch (Exception e) {
            LOG.info("No task of " + workerId);
        }
    }

    public void close() throws IOException {
        this.center.delete(this.rootCgroup);
    }

    private void prepareSubSystem() {
        this.h = this.center.busy(SubSystemType.cpu);
        if (this.h == null) {
            HashSet<SubSystemType> types = new HashSet<SubSystemType>();
            types.add(SubSystemType.cpu);
            this.h = new Hierarchy(JSTORM_HIERARCHY_NAME, types, JSTORM_CPU_HIERARCHY_DIR);
        }
        this.rootCgroup = new CgroupCommon(rootDir, this.h, this.h.getRootCgroups());
    }
}

