/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import backtype.storm.utils.LocalState;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.daemon.supervisor.MachineCheckStatus;
import com.alibaba.jstorm.daemon.supervisor.SupervisorInfo;
import com.alibaba.jstorm.utils.JStormServerUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Heartbeat
extends RunnableCallback {
    private static Logger LOG = LoggerFactory.getLogger(Heartbeat.class);
    private static final int CPU_THREADHOLD = 4;
    private static final long MEM_THREADHOLD = 8L * JStormUtils.SIZE_1_G;
    private Map<Object, Object> conf;
    private StormClusterState stormClusterState;
    private String supervisorId;
    private String myHostName;
    private final int startTime;
    private final int frequence;
    private SupervisorInfo supervisorInfo;
    private AtomicBoolean hbUpdateTrigger;
    protected MachineCheckStatus oldCheckStatus;
    protected volatile MachineCheckStatus checkStatus;
    private LocalState localState;

    public Heartbeat(Map conf, StormClusterState stormClusterState, String supervisorId, LocalState localState, MachineCheckStatus status) {
        String myHostName = JStormServerUtils.getHostName(conf);
        this.stormClusterState = stormClusterState;
        this.supervisorId = supervisorId;
        this.conf = conf;
        this.myHostName = myHostName;
        this.startTime = TimeUtils.current_time_secs();
        this.frequence = JStormUtils.parseInt(conf.get("supervisor.heartbeat.frequency.secs"));
        this.hbUpdateTrigger = new AtomicBoolean(true);
        this.localState = localState;
        this.checkStatus = status;
        this.oldCheckStatus = new MachineCheckStatus();
        this.oldCheckStatus.SetType(this.checkStatus.getType());
        this.initSupervisorInfo(conf);
        LOG.info("Successfully init supervisor heartbeat thread, " + this.supervisorInfo);
    }

    private void initSupervisorInfo(Map conf) {
        List<Integer> portList = JStormUtils.getSupervisorPortList(conf);
        if (!StormConfig.local_mode(conf)) {
            try {
                boolean isLocaliP = false;
                boolean bl = isLocaliP = this.myHostName.equals("127.0.0.1") || this.myHostName.equals("localhost");
                if (isLocaliP) {
                    throw new Exception("the hostname which  supervisor get is localhost");
                }
            }
            catch (Exception e1) {
                LOG.error("get supervisor host error!", (Throwable)e1);
                throw new RuntimeException(e1);
            }
            Set<Integer> ports = JStormUtils.listToSet(portList);
            this.supervisorInfo = new SupervisorInfo(this.myHostName, this.supervisorId, ports);
        } else {
            Set<Integer> ports = JStormUtils.listToSet(portList);
            this.supervisorInfo = new SupervisorInfo(this.myHostName, this.supervisorId, ports);
        }
    }

    public void update() {
        this.supervisorInfo.setTimeSecs(TimeUtils.current_time_secs());
        this.supervisorInfo.setUptimeSecs(TimeUtils.current_time_secs() - this.startTime);
        if (!this.checkStatus.equals(this.oldCheckStatus)) {
            if (this.checkStatus.getType() == MachineCheckStatus.StatusType.warning || this.checkStatus.getType() == MachineCheckStatus.StatusType.error || this.checkStatus.getType() == MachineCheckStatus.StatusType.panic) {
                HashSet<Integer> ports = new HashSet<Integer>();
                this.supervisorInfo.setWorkerPorts(ports);
                LOG.warn("due to no enough resourse, limit supervisor's ports and block scheduling");
            } else {
                this.updateSupervisorInfo();
            }
            this.oldCheckStatus.SetType(this.checkStatus.getType());
        } else {
            this.updateSupervisorInfo();
        }
        try {
            this.stormClusterState.supervisor_heartbeat(this.supervisorId, this.supervisorInfo);
        }
        catch (Exception e) {
            LOG.error("Failed to update SupervisorInfo to ZK", (Throwable)e);
        }
    }

    private void updateSupervisorInfo() {
        List<Integer> portList = this.calculatorAvailablePorts();
        Set<Integer> ports = JStormUtils.listToSet(portList);
        this.supervisorInfo.setWorkerPorts(ports);
    }

    public MachineCheckStatus getCheckStatus() {
        return this.checkStatus;
    }

    @Override
    public Object getResult() {
        return this.frequence;
    }

    @Override
    public void run() {
        boolean updateHb = this.hbUpdateTrigger.getAndSet(false);
        if (updateHb) {
            this.update();
        }
    }

    public int getStartTime() {
        return this.startTime;
    }

    public SupervisorInfo getSupervisorInfo() {
        return this.supervisorInfo;
    }

    public void updateHbTrigger(boolean update) {
        this.hbUpdateTrigger.set(update);
    }

    private List<Integer> calculatorAvailablePorts() {
        long reserveMemory;
        if (JStormUtils.getTotalCpuUsage() <= 0.0) {
            return JStormUtils.getSupervisorPortList(this.conf);
        }
        long freeMemory = JStormUtils.getFreePhysicalMem() * 1024L;
        if (freeMemory < (reserveMemory = ConfigExtension.getStormMachineReserveMem(this.conf))) {
            List<Integer> list2 = null;
            try {
                list2 = this.getLocalAssignmentPortList();
            }
            catch (IOException e) {
                return JStormUtils.getSupervisorPortList(this.conf);
            }
            if (list2 == null) {
                return new ArrayList<Integer>();
            }
            return list2;
        }
        int reserveCpuUsage = ConfigExtension.getStormMachineReserveCpuPercent(this.conf);
        double cpuUsage = JStormUtils.getTotalCpuUsage();
        if (cpuUsage > 100.0 - (double)reserveCpuUsage) {
            List<Integer> list3 = null;
            try {
                list3 = this.getLocalAssignmentPortList();
            }
            catch (IOException e) {
                return JStormUtils.getSupervisorPortList(this.conf);
            }
            if (list3 == null) {
                return new ArrayList<Integer>();
            }
            return list3;
        }
        Long conversionAvailableCpuNum = Math.round((100.0 - cpuUsage) / 100.0 * (double)JStormUtils.getNumProcessors());
        Long availablePhysicalMemorySize = freeMemory - reserveMemory;
        int portNum = JStormUtils.getSupervisorPortNum(this.conf, conversionAvailableCpuNum.intValue(), availablePhysicalMemorySize, true);
        List<Integer> portList = JStormUtils.getSupervisorPortList(this.conf);
        List<Integer> usedList = null;
        try {
            usedList = this.getLocalAssignmentPortList();
        }
        catch (Exception e) {
            return JStormUtils.getSupervisorPortList(this.conf);
        }
        portList.removeAll(usedList);
        Collections.sort(portList);
        if (portNum >= portList.size()) {
            return JStormUtils.getSupervisorPortList(this.conf);
        }
        ArrayList<Integer> reportPortList = new ArrayList<Integer>();
        reportPortList.addAll(usedList);
        for (int i = 1; i <= portNum; ++i) {
            reportPortList.add(portList.get(i));
        }
        return reportPortList;
    }

    private List<Integer> getLocalAssignmentPortList() throws IOException {
        Map localAssignment = null;
        try {
            localAssignment = (Map)this.localState.get("local-assignments");
        }
        catch (IOException e) {
            LOG.error("get LS_LOCAL_ASSIGNMENTS of localState failed .");
            throw e;
        }
        if (localAssignment == null) {
            return null;
        }
        return JStormUtils.mk_list(localAssignment.keySet());
    }
}

