/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import backtype.storm.daemon.Shutdownable;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.daemon.worker.Worker;
import com.alibaba.jstorm.utils.FileAttribute;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.Pair;
import com.alibaba.jstorm.utils.PathUtils;
import com.alibaba.jstorm.utils.TimeFormat;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Httpserver
implements Shutdownable {
    private static Logger LOG = LoggerFactory.getLogger(Httpserver.class);
    private HttpServer hs;
    private int port;
    private Map conf;

    public Httpserver(int port, Map conf) {
        this.port = port;
        this.conf = conf;
    }

    public void start() {
        int numHandler = 3;
        InetSocketAddress socketAddr = new InetSocketAddress(this.port);
        ExecutorService executor = Executors.newFixedThreadPool(numHandler);
        try {
            this.hs = HttpServer.create(socketAddr, 0);
            this.hs.createContext("/logview", new LogHandler(this.conf));
            this.hs.setExecutor(executor);
            this.hs.start();
        }
        catch (BindException e) {
            LOG.info("HttpServer Already start!");
            this.hs = null;
            return;
        }
        catch (IOException e) {
            LOG.error("HttpServer Start Failed", (Throwable)e);
            this.hs = null;
            return;
        }
        LOG.info("Success start HttpServer at port:" + this.port);
    }

    @Override
    public void shutdown() {
        if (this.hs != null) {
            this.hs.stop(0);
            LOG.info("Successfully stop http server");
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap conf = new HashMap();
        LogHandler logHandler = new LogHandler(conf);
        logHandler.setDebug(true);
        logHandler.setLogDir("/Users/wuchong/Downloads/");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file", "SequenceTest6-worker-6800.log");
        logHandler.handleSearchLog(null, params);
        params.put("key", "info");
        logHandler.handleSearchLog(null, params);
        params.put("case_ignore", "true");
        logHandler.handleSearchLog(null, params);
        params.put("offset", "7481");
        logHandler.handleSearchLog(null, params);
    }

    static class LogHandler
    implements HttpHandler {
        private String logDir;
        private String stormHome;
        private ArrayList<String> accessDirs = new ArrayList();
        Map conf;
        private final int pageSize;
        private boolean debug = false;

        public LogHandler(Map conf) {
            String confDirPath;
            String confDir;
            this.pageSize = ConfigExtension.getLogPageSize(conf);
            this.logDir = JStormUtils.getLogDir();
            String logDirPath = PathUtils.getCanonicalPath(this.logDir);
            if (logDirPath == null) {
                this.accessDirs.add(this.logDir);
            } else {
                this.accessDirs.add(logDirPath);
            }
            this.stormHome = System.getProperty("jstorm.home");
            if (this.stormHome != null) {
                String stormHomePath = PathUtils.getCanonicalPath(this.stormHome);
                if (stormHomePath == null) {
                    this.accessDirs.add(this.stormHome);
                } else {
                    this.accessDirs.add(stormHomePath);
                }
            }
            if (!StringUtils.isBlank((String)(confDir = System.getProperty("JSTORM_CONF_DIR"))) && (confDirPath = PathUtils.getCanonicalPath(confDir)) != null) {
                this.accessDirs.add(confDirPath);
            }
            this.conf = conf;
            LOG.info("logview logDir=" + this.logDir);
        }

        @VisibleForTesting
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @VisibleForTesting
        public void setLogDir(String dir) {
            this.logDir = dir;
        }

        public void handlFailure(HttpExchange t, String errorMsg) throws IOException {
            LOG.error(errorMsg);
            byte[] data = errorMsg.getBytes();
            this.sendResponse(t, 400, data);
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            URI uri = t.getRequestURI();
            Map<String, String> paramMap = this.parseRawQuery(uri.getRawQuery());
            LOG.info("Receive command " + paramMap);
            String cmd = paramMap.get("cmd");
            if (StringUtils.isBlank((String)cmd)) {
                this.handlFailure(t, "Bad Request, Not set command type");
                return;
            }
            if ("showLog".equals(cmd)) {
                this.handleShowLog(t, paramMap);
            } else if ("listDir".equals(cmd)) {
                this.handleListDir(t, paramMap);
            } else if ("jstack".equals(cmd)) {
                this.handleJstack(t, paramMap);
            } else if ("showConf".equals(cmd)) {
                this.handleShowConf(t, paramMap);
            } else if ("searchLog".equals(cmd)) {
                this.handleSearchLog(t, paramMap);
            } else if ("download".equals(cmd)) {
                this.handleDownloadLog(t, paramMap);
            } else {
                this.handlFailure(t, "Bad Request, Not support command type " + cmd);
            }
        }

        private void accessCheck(String fileName) throws IOException {
            if (this.debug) {
                return;
            }
            File file = new File(fileName);
            String canonicalPath = file.getCanonicalPath();
            boolean isChild = false;
            for (String dir : this.accessDirs) {
                if (!canonicalPath.contains(dir)) continue;
                isChild = true;
                break;
            }
            if (!isChild) {
                LOG.error("Access one disallowed path: " + canonicalPath);
                throw new IOException("Destination file/path is not accessible.");
            }
        }

        private Map<String, String> parseRawQuery(String uriRawQuery) {
            HashMap paramMap = Maps.newHashMap();
            for (String param : StringUtils.split((String)uriRawQuery, (String)"&")) {
                String[] pair = StringUtils.split((String)param, (String)"=");
                if (pair.length != 2) continue;
                paramMap.put(pair[0], pair[1]);
            }
            return paramMap;
        }

        private void handleShowLog(HttpExchange t, Map<String, String> paramMap) throws IOException {
            Pair<Long, byte[]> logPair = this.queryLog(t, paramMap);
            if (logPair == null) {
                return;
            }
            String size = String.format("%016d\n", logPair.getFirst());
            byte[] sizeByts = size.getBytes();
            byte[] logData = logPair.getSecond();
            t.sendResponseHeaders(200, sizeByts.length + logData.length);
            OutputStream os = t.getResponseBody();
            os.write(sizeByts);
            os.write(logData);
            os.close();
        }

        private void handleDownloadLog(HttpExchange t, Map<String, String> paramMap) throws IOException {
            Pair<Long, byte[]> logPair = this.queryLog(t, paramMap);
            this.sendResponse(t, 200, logPair.getSecond());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private Pair<Long, byte[]> queryLog(HttpExchange t, Map<String, String> paramMap) throws IOException {
            Pair<Long, byte[]> pair;
            block13: {
                String fileParam = paramMap.get("log");
                String _pageSize = paramMap.get("size");
                if (StringUtils.isBlank((String)fileParam)) {
                    this.handlFailure(t, "Bad Request, Params Error, no log file name.");
                    return null;
                }
                int pageSize = this.pageSize;
                if (!StringUtils.isBlank((String)_pageSize)) {
                    pageSize = JStormUtils.parseInt(_pageSize, this.pageSize);
                }
                String logFile = Joiner.on((String)File.separator).join((Object)this.logDir, (Object)fileParam, new Object[0]);
                this.accessCheck(logFile);
                FileChannel fc = null;
                try {
                    fc = new RandomAccessFile(logFile, "r").getChannel();
                    long fileSize = fc.size();
                    long position = fileSize - (long)pageSize;
                    try {
                        String posStr = paramMap.get("pos");
                        if (!StringUtils.isBlank((String)posStr)) {
                            position = Long.valueOf(posStr);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Invalide position " + position);
                    }
                    if (position < 0L) {
                        position = 0L;
                    }
                    long size = Math.min(fileSize - position, (long)pageSize);
                    LOG.info("logview " + logFile + ", position=" + position + ", size=" + size);
                    MappedByteBuffer fout = fc.map(FileChannel.MapMode.READ_ONLY, position, size);
                    byte[] ret = new byte[(int)size];
                    fout.get(ret);
                    String str = new String(ret, ConfigExtension.getLogViewEncoding(this.conf));
                    pair = new Pair<Long, byte[]>(fileSize, str.getBytes());
                    if (fc == null) break block13;
                }
                catch (FileNotFoundException e) {
                    Pair<Long, byte[]> pair2;
                    block14: {
                        LOG.warn(e.getMessage(), (Throwable)e);
                        this.handlFailure(t, "Bad Request, Failed to find " + fileParam);
                        pair2 = null;
                        if (fc == null) break block14;
                        IOUtils.closeQuietly((Closeable)fc);
                    }
                    return pair2;
                }
                catch (IOException e2) {
                    Pair<Long, byte[]> pair3;
                    block15: {
                        LOG.warn(e2.getMessage(), (Throwable)e2);
                        this.handlFailure(t, "Bad Request, Failed to open " + fileParam);
                        pair3 = null;
                        if (fc == null) break block15;
                        {
                            catch (Throwable throwable) {
                                if (fc != null) {
                                    IOUtils.closeQuietly(fc);
                                }
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)fc);
                    }
                    return pair3;
                }
                IOUtils.closeQuietly((Closeable)fc);
            }
            return pair;
        }

        byte[] getJSonFiles(String dir) throws Exception {
            String[] files;
            HashMap<String, FileAttribute> fileMap = new HashMap<String, FileAttribute>();
            String path = this.logDir;
            if (dir != null) {
                path = path + File.separator + dir;
            }
            this.accessCheck(path);
            LOG.info("List dir " + path);
            File file = new File(path);
            for (String fileName : files = file.list()) {
                String logFile = Joiner.on((String)File.separator).join((Object)path, (Object)fileName, new Object[0]);
                FileAttribute fileAttribute = new FileAttribute();
                fileAttribute.setFileName(fileName);
                File subFile = new File(logFile);
                Date modify = new Date(subFile.lastModified());
                fileAttribute.setModifyTime(TimeFormat.getSecond(modify));
                if (subFile.isFile()) {
                    fileAttribute.setIsDir(String.valueOf(false));
                    fileAttribute.setSize(String.valueOf(subFile.length()));
                    fileMap.put(logFile, fileAttribute);
                    continue;
                }
                if (!subFile.isDirectory()) continue;
                fileAttribute.setIsDir(String.valueOf(true));
                fileAttribute.setSize(String.valueOf(4096));
                fileMap.put(logFile, fileAttribute);
            }
            String fileJsonStr = JStormUtils.to_json(fileMap);
            return fileJsonStr.getBytes();
        }

        void handleListDir(HttpExchange t, Map<String, String> paramMap) throws IOException {
            byte[] filesJson;
            try {
                String dir = paramMap.get("dir");
                filesJson = this.getJSonFiles(dir);
            }
            catch (Exception e) {
                LOG.error("Failed to list files", (Throwable)e);
                this.handlFailure(t, "Failed to get file list");
                return;
            }
            this.sendResponse(t, 200, filesJson);
        }

        void handleSearchLog(HttpExchange t, Map<String, String> paramMap) throws IOException {
            int maxMatch = JStormUtils.parseInt(paramMap.get("max_match"), ConfigExtension.getMaxMatchPerLogSearch(this.conf));
            long offset = JStormUtils.parseLong(paramMap.get("offset"), 0L);
            String logFile = paramMap.get("file");
            int lookBack = JStormUtils.parseInt(paramMap.get("look_back"), 2);
            int lookAhead = JStormUtils.parseInt(paramMap.get("look_ahead"), 10);
            boolean caseIgnore = JStormUtils.parseBoolean(paramMap.get("case_ignore"), false);
            int maxBlocks = ConfigExtension.getMaxBlocksPerLogSearch(this.conf);
            int blockSize = 16384;
            String key = paramMap.get("key");
            if (caseIgnore) {
                key = key.toLowerCase();
            }
            key = URLDecoder.decode(key, "UTF-8");
            Map<Object, Object> ret = new HashMap<Object, Object>();
            if (StringUtils.isBlank((String)key)) {
                this.error(ret, "search key cannot be empty!");
                String resp = JStormUtils.to_json(ret);
                this.sendResponse(t, 200, resp);
                return;
            }
            if (this.debug) {
                System.out.println("Search for key:" + key);
                System.out.println("===================================\n");
            }
            logFile = Joiner.on((String)File.separator).join((Object)this.logDir, (Object)logFile, new Object[0]);
            this.accessCheck(logFile);
            String searchFrom = paramMap.get("search_from");
            ret = searchFrom != null && searchFrom.equals("head") ? this.searchFromHead(logFile, offset, key, maxMatch, lookBack, lookAhead, maxBlocks, blockSize, caseIgnore) : this.searchFromTail(logFile, offset, key, maxMatch, lookBack, lookAhead, maxBlocks, blockSize, caseIgnore);
            String resp = JStormUtils.to_json(ret);
            this.sendResponse(t, 200, resp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map<Object, Object> searchFromTail(String logFile, long offset, String key, int maxMatch, int lookBack, int lookAhead, int maxBlocks, int blockSize, boolean caseIgnore) throws IOException {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            HashMap<Long, String> matchResults = new HashMap<Long, String>();
            int match = 0;
            String encoding = ConfigExtension.getLogViewEncoding(this.conf);
            FileChannel fc = null;
            try {
                RandomAccessFile randomAccess = new RandomAccessFile(logFile, "r");
                fc = randomAccess.getChannel();
                long fileSize = fc.size();
                if (offset == 0L || offset < fileSize) {
                    long pos = fileSize;
                    if (offset > 0L) {
                        pos = offset;
                    }
                    long matchOffset = pos;
                    int jumpLines = 0;
                    StringBuilder matchContent = new StringBuilder();
                    for (int i = 0; i < maxBlocks && pos > 0L && match < maxMatch; ++i) {
                        int lineBreakOffset;
                        int j;
                        long bufferSize = blockSize;
                        if (pos < (long)blockSize) {
                            bufferSize = pos;
                            pos = 0L;
                        } else {
                            pos -= bufferSize;
                        }
                        MappedByteBuffer fout = fc.map(FileChannel.MapMode.READ_ONLY, pos, bufferSize);
                        byte[] buffer = new byte[(int)bufferSize];
                        fout.get(buffer);
                        String data = new String(buffer, encoding);
                        String[] lines = data.split("\\r\\n|\\n|\\r");
                        int[] line2pos = new int[lines.length];
                        for (j = 0; j < lines.length; ++j) {
                            line2pos[j] = lines[j].getBytes(encoding).length;
                            if (j <= 0) continue;
                            int n = j;
                            line2pos[n] = line2pos[n] + line2pos[j - 1];
                        }
                        j = 0;
                        while (j < lines.length) {
                            boolean isMatch;
                            String line = lines[j];
                            boolean bl = isMatch = caseIgnore ? line.toLowerCase().contains(key) : line.contains(key);
                            if (isMatch) {
                                int start = Math.max(0, j - lookBack);
                                long l = matchOffset = start > 0 ? pos + (long)line2pos[start - 1] : pos;
                                if ((j += lookAhead) >= lines.length) {
                                    jumpLines = j - lines.length + 1;
                                    j = lines.length - 1;
                                }
                                ++match;
                                for (int k = start; k < j; ++k) {
                                    matchContent.append(lines[k]).append("\n");
                                }
                                if (jumpLines > 0) {
                                    this.readJumpLines(randomAccess, pos + (long)line2pos[j], jumpLines, matchContent);
                                    jumpLines = 0;
                                    j = lines.length;
                                }
                                matchResults.put(matchOffset, matchContent.toString());
                                if (this.debug) {
                                    System.out.println("==== match " + match + " ==== offset: " + matchOffset);
                                    System.out.println(matchContent.toString());
                                    System.out.println();
                                }
                                matchContent = new StringBuilder();
                                continue;
                            }
                            ++j;
                        }
                        if (match >= maxMatch || pos <= 0L || (lineBreakOffset = lines[0].getBytes(encoding).length) >= blockSize) continue;
                        pos += (long)lineBreakOffset;
                    }
                    ret.put("num_match", match);
                    ret.put("match_results", matchResults);
                    ret.put("next_offset", pos);
                } else {
                    this.error(ret, "pos exceeds file size!");
                }
                if (fc == null) return ret;
            }
            catch (FileNotFoundException e) {
                LOG.warn("Error", (Throwable)e);
                this.error(ret, "Bad Request, Failed to find " + logFile);
                if (fc == null) return ret;
                IOUtils.closeQuietly((Closeable)fc);
                return ret;
            }
            catch (IOException e) {
                LOG.warn("Error", (Throwable)e);
                this.error(ret, "Bad Request, Failed to open " + logFile);
                if (fc == null) return ret;
                {
                    catch (Throwable throwable) {
                        if (fc == null) throw throwable;
                        IOUtils.closeQuietly(fc);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)fc);
                return ret;
            }
            IOUtils.closeQuietly((Closeable)fc);
            return ret;
        }

        private void readJumpLines(RandomAccessFile randomAccessFile, long pos, int lines, StringBuilder matchContent) {
            try {
                randomAccessFile.seek(pos);
                while (lines-- > 0) {
                    String line = randomAccessFile.readLine();
                    if (line == null) continue;
                    matchContent.append(line).append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map<Object, Object> searchFromHead(String logFile, long offset, String key, int maxMatch, int lookBack, int lookAhead, int maxBlocks, int blockSize, boolean caseIgnore) throws IOException {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            HashMap<Long, String> matchResults = new HashMap<Long, String>();
            int match = 0;
            String encoding = ConfigExtension.getLogViewEncoding(this.conf);
            FileChannel fc = null;
            try {
                fc = new RandomAccessFile(logFile, "r").getChannel();
                long fileSize = fc.size();
                if (offset < fileSize) {
                    long pos = offset;
                    long matchOffset = offset;
                    int jumpLines = 0;
                    StringBuilder matchContent = new StringBuilder();
                    for (int i = 0; i < maxBlocks && pos < fileSize && match < maxMatch; ++i) {
                        int j;
                        long bufferSize = Math.min(fc.size() - pos, (long)blockSize);
                        MappedByteBuffer fout = fc.map(FileChannel.MapMode.READ_ONLY, pos, bufferSize);
                        byte[] buffer = new byte[(int)bufferSize];
                        fout.get(buffer);
                        String data = new String(buffer, encoding);
                        String[] lines = data.split("\\r\\n|\\n|\\r");
                        int[] line2pos = new int[lines.length];
                        for (j = 0; j < lines.length; ++j) {
                            line2pos[j] = lines[j].getBytes(encoding).length;
                            if (j <= 0) continue;
                            int n = j;
                            line2pos[n] = line2pos[n] + line2pos[j - 1];
                        }
                        j = 0;
                        while (j < lines.length && match < maxMatch) {
                            boolean isMatch;
                            if (jumpLines > 0) {
                                for (int m = 0; m < jumpLines && m < lines.length; ++m) {
                                    matchContent.append(lines[m]).append("\n");
                                }
                                j = jumpLines;
                                jumpLines = 0;
                                matchResults.put(matchOffset, matchContent.toString());
                                if (this.debug) {
                                    System.out.println("==== match " + match + " ==== offset: " + matchOffset);
                                    System.out.println(matchContent.toString());
                                    System.out.println();
                                }
                                matchContent = new StringBuilder();
                                continue;
                            }
                            String line = lines[j];
                            boolean bl = isMatch = caseIgnore ? line.toLowerCase().contains(key) : line.contains(key);
                            if (isMatch) {
                                int start = Math.max(0, j - lookBack);
                                long l = matchOffset = start > 0 ? pos + (long)line2pos[start - 1] : pos;
                                if ((j += lookAhead) >= lines.length) {
                                    jumpLines = j - lines.length + 1;
                                    j = lines.length - 1;
                                }
                                if (++match >= maxMatch) {
                                    pos += (long)line2pos[j];
                                }
                                for (int k = start; k < j; ++k) {
                                    matchContent.append(lines[k]).append("\n");
                                }
                                if (jumpLines == 0 || match >= maxMatch) {
                                    matchResults.put(matchOffset, matchContent.toString());
                                    if (this.debug) {
                                        System.out.println("==== match " + match + " ==== offset: " + matchOffset);
                                        System.out.println(matchContent.toString());
                                        System.out.println();
                                    }
                                    matchContent = new StringBuilder();
                                    continue;
                                }
                                ++j;
                                continue;
                            }
                            ++j;
                        }
                        if (match >= maxMatch) continue;
                        int lineBreakOffset = lines[lines.length - 1].getBytes(encoding).length;
                        if (lineBreakOffset < blockSize) {
                            pos = pos + (long)blockSize - (long)lineBreakOffset;
                            continue;
                        }
                        pos += (long)blockSize;
                    }
                    ret.put("num_match", match);
                    ret.put("match_results", matchResults);
                    ret.put("next_offset", pos);
                } else {
                    this.error(ret, "pos exceeds file size!");
                }
                if (fc == null) return ret;
            }
            catch (FileNotFoundException e) {
                LOG.warn("Error", (Throwable)e);
                this.error(ret, "Bad Request, Failed to find " + logFile);
                if (fc == null) return ret;
                IOUtils.closeQuietly((Closeable)fc);
                return ret;
            }
            catch (IOException e) {
                LOG.warn("Error", (Throwable)e);
                this.error(ret, "Bad Request, Failed to open " + logFile);
                if (fc == null) return ret;
                {
                    catch (Throwable throwable) {
                        if (fc == null) throw throwable;
                        IOUtils.closeQuietly(fc);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)fc);
                return ret;
            }
            IOUtils.closeQuietly((Closeable)fc);
            return ret;
        }

        void error(Map<Object, Object> ret, String msg) {
            ret.put("error", true);
            ret.put("msg", msg);
        }

        void handleJstack(StringBuilder sb, Integer pid) {
            String cmd = "jstack " + pid;
            try {
                LOG.info("Begin to execute " + cmd);
                String output = JStormUtils.launchProcess(cmd, new HashMap<String, String>(), false);
                sb.append(output);
                LOG.info("Successfully get output of " + cmd);
            }
            catch (IOException e) {
                LOG.info("Failed to execute " + cmd, (Throwable)e);
                sb.append("Failed to execute " + cmd);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                sb.append("Failed to execute " + cmd + ", " + e.getCause());
            }
        }

        void handleJstack(HttpExchange t, Map<String, String> paramMap) throws IOException {
            String workerPort = paramMap.get("workerPort");
            if (workerPort == null) {
                this.handlFailure(t, "Not set worker's port");
                return;
            }
            LOG.info("Begin to get jstack of " + workerPort);
            StringBuilder sb = new StringBuilder();
            List<Integer> pids = Worker.getOldPortPids(workerPort);
            for (Integer pid : pids) {
                sb.append("!!!!!!!!!!!!!!!!!!\r\n");
                sb.append("WorkerPort:" + workerPort + ", pid:" + pid);
                sb.append("\r\n!!!!!!!!!!!!!!!!!!\r\n");
                this.handleJstack(sb, pid);
            }
            byte[] data = sb.toString().getBytes();
            this.sendResponse(t, 200, data);
        }

        void handleShowConf(HttpExchange t, Map<String, String> paramMap) throws IOException {
            byte[] json;
            try {
                String tmp = Utils.to_json(this.conf);
                json = tmp.getBytes();
            }
            catch (Exception e) {
                LOG.error("Failed to get configuration", (Throwable)e);
                this.handlFailure(t, "Failed to get configuration");
                return;
            }
            this.sendResponse(t, 200, json);
        }

        void sendResponse(HttpExchange t, int retCode, String data) throws IOException {
            if (this.debug) {
                LOG.info("HTTP:{}, search result:{}", (Object)retCode, (Object)data);
            }
            byte[] bytes = data.getBytes();
            this.sendResponse(t, retCode, bytes);
        }

        void sendResponse(HttpExchange t, int retCode, byte[] data) throws IOException {
            if (t != null) {
                t.sendResponseHeaders(retCode, data.length);
                OutputStream os = t.getResponseBody();
                os.write(data);
                os.close();
            }
        }
    }
}

