/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandBoxMaker {
    private static final Logger LOG = LoggerFactory.getLogger(SandBoxMaker.class);
    public static final String SANBOX_TEMPLATE_NAME = "sandbox.policy";
    public static final String JSTORM_HOME_KEY = "%JSTORM_HOME%";
    public static final String CLASS_PATH_KEY = "%CLASS_PATH%";
    public static final String LOCAL_DIR_KEY = "%JSTORM_LOCAL_DIR%";
    private final Map conf;
    private final boolean isEnable;
    private final Map<String, String> replaceBaseMap = new HashMap<String, String>();

    public SandBoxMaker(Map conf) {
        this.conf = conf;
        this.isEnable = ConfigExtension.isJavaSandBoxEnable(conf);
        LOG.info("Java Sandbox Policy :" + String.valueOf(this.isEnable));
        String jstormHome = System.getProperty("jstorm.home");
        if (jstormHome == null) {
            jstormHome = "./";
        }
        this.replaceBaseMap.put(JSTORM_HOME_KEY, jstormHome);
        this.replaceBaseMap.put(LOCAL_DIR_KEY, (String)conf.get("storm.local.dir"));
        LOG.info("JSTORM_HOME is " + jstormHome);
    }

    private String genClassPath(String classPathLine) {
        String[] classPathes;
        StringBuilder sb = new StringBuilder();
        for (String classpath : classPathes = classPathLine.split(":")) {
            if (StringUtils.isBlank((String)classpath)) continue;
            File file = new File(classpath);
            if (file.isDirectory()) {
                sb.append(" permission java.io.FilePermission \"");
                sb.append(classpath).append(File.separator).append("**");
                sb.append("\", \"read\";\n");
                continue;
            }
            sb.append(" permission java.io.FilePermission \"");
            sb.append(classpath);
            sb.append("\", \"read\";\n");
        }
        return sb.toString();
    }

    private String replaceLine(String line, Map<String, String> replaceMap) {
        for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
            if (line.contains(CLASS_PATH_KEY)) {
                return this.genClassPath(entry.getValue());
            }
            if (!line.contains(entry.getKey())) continue;
            return line.replace(entry.getKey(), entry.getValue());
        }
        return line;
    }

    public String generatePolicyFile(Map<String, String> replaceMap) throws IOException {
        String tmpPolicy = StormConfig.supervisorTmpDir(this.conf) + File.separator + UUID.randomUUID().toString();
        InputStream inputStream = SandBoxMaker.class.getClassLoader().getResourceAsStream(SANBOX_TEMPLATE_NAME);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(tmpPolicy)));
        BufferedReader reader = null;
        InputStreamReader inputReader = null;
        try {
            inputReader = new InputStreamReader(inputStream);
            reader = new BufferedReader(new LineNumberReader(inputReader));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String replaced = this.replaceLine(line, replaceMap);
                writer.println(replaced);
            }
            String string = tmpPolicy;
            return string;
        }
        catch (Exception e) {
            LOG.error("Failed to generate policy file\n", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (inputReader != null) {
                inputReader.close();
            }
        }
    }

    public String sandboxPolicy(String workerId, Map<String, String> replaceMap) throws IOException {
        if (!this.isEnable) {
            return "";
        }
        replaceMap.putAll(this.replaceBaseMap);
        String tmpPolicy = this.generatePolicyFile(replaceMap);
        File file = new File(tmpPolicy);
        String policyPath = StormConfig.worker_root(this.conf, workerId) + File.separator + SANBOX_TEMPLATE_NAME;
        File dest = new File(policyPath);
        file.renameTo(dest);
        StringBuilder sb = new StringBuilder();
        sb.append(" -Djava.security.manager -Djava.security.policy=");
        sb.append(policyPath);
        return sb.toString();
    }

    public static void main(String[] args) {
        Map conf = Utils.readStormConfig();
        conf.put("java.sandbox.enable", true);
        SandBoxMaker maker = new SandBoxMaker(conf);
        try {
            System.out.println("sandboxPolicy:" + maker.sandboxPolicy("simple", new HashMap<String, String>()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

