/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import backtype.storm.command.health;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.daemon.supervisor.MachineCheckStatus;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorHealth
extends RunnableCallback {
    private static Logger LOG = LoggerFactory.getLogger(SupervisorHealth.class);
    private Map<Object, Object> conf;
    private final int frequence;
    private volatile MachineCheckStatus checkStatus;
    private long timeOut;
    private String supervisorId;
    private AtomicBoolean active = null;
    private Integer result;

    public SupervisorHealth(Map conf, MachineCheckStatus status, String supervisorId) {
        this.conf = conf;
        this.supervisorId = supervisorId;
        this.frequence = ConfigExtension.getSupervisorFrequencyCheck(conf);
        this.timeOut = ConfigExtension.getStormHealthTimeoutMs(conf);
        this.active = new AtomicBoolean(true);
        this.checkStatus = status;
        String errorDir = ConfigExtension.getStormMachineResourceErrorCheckDir(conf);
        String panicDir = ConfigExtension.getStormMachineResourcePanicCheckDir(conf);
        String warnDir = ConfigExtension.getStormMachineResourceWarningCheckDir(conf);
        LOG.info("start supervisor health check , timeout is " + this.timeOut + "," + " scripts directory is: " + panicDir + ";" + errorDir + ";" + warnDir);
    }

    public void updateStatus() {
        MachineCheckStatus checkStatus = health.check();
        this.checkStatus.SetType(checkStatus.getType());
    }

    @Override
    public Object getResult() {
        this.result = this.active.get() ? Integer.valueOf(this.frequence) : Integer.valueOf(-1);
        return this.result;
    }

    @Override
    public void run() {
        this.updateStatus();
    }

    public void setActive(boolean active) {
        this.active.getAndSet(active);
    }
}

