/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.supervisor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SupervisorInfo
implements Serializable {
    private static final long serialVersionUID = -8384417078907518922L;
    private final String hostName;
    private final String supervisorId;
    private Integer timeSecs;
    private Integer uptimeSecs;
    private Set<Integer> workerPorts;
    private transient Set<Integer> availableWorkerPorts;

    public SupervisorInfo(String hostName, String supervisorId, Set<Integer> workerPorts) {
        this.hostName = hostName;
        this.supervisorId = supervisorId;
        this.workerPorts = workerPorts;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSupervisorId() {
        return this.supervisorId;
    }

    public int getTimeSecs() {
        return this.timeSecs;
    }

    public void setTimeSecs(int timeSecs) {
        this.timeSecs = timeSecs;
    }

    public int getUptimeSecs() {
        return this.uptimeSecs;
    }

    public void setUptimeSecs(int uptimeSecs) {
        this.uptimeSecs = uptimeSecs;
    }

    public Set<Integer> getWorkerPorts() {
        return this.workerPorts;
    }

    public void setAvailableWorkerPorts(Set<Integer> workerPorts) {
        if (this.availableWorkerPorts == null) {
            this.availableWorkerPorts = new HashSet<Integer>();
        }
        this.availableWorkerPorts.addAll(workerPorts);
    }

    public Set<Integer> getAvailableWorkerPorts() {
        if (this.availableWorkerPorts == null) {
            this.availableWorkerPorts = new HashSet<Integer>();
        }
        return this.availableWorkerPorts;
    }

    public void setWorkerPorts(Set<Integer> workerPorts) {
        this.workerPorts = workerPorts;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.hostName == null ? 0 : this.hostName.hashCode());
        result2 = 31 * result2 + (this.supervisorId == null ? 0 : this.supervisorId.hashCode());
        result2 = 31 * result2 + (this.timeSecs == null ? 0 : this.timeSecs.hashCode());
        result2 = 31 * result2 + (this.uptimeSecs == null ? 0 : this.uptimeSecs.hashCode());
        result2 = 31 * result2 + (this.workerPorts == null ? 0 : this.workerPorts.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupervisorInfo other = (SupervisorInfo)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.supervisorId == null ? other.supervisorId != null : !this.supervisorId.equals(other.supervisorId)) {
            return false;
        }
        if (this.timeSecs == null ? other.timeSecs != null : !this.timeSecs.equals(other.timeSecs)) {
            return false;
        }
        if (this.uptimeSecs == null ? other.uptimeSecs != null : !this.uptimeSecs.equals(other.uptimeSecs)) {
            return false;
        }
        return !(this.workerPorts == null ? other.workerPorts != null : !this.workerPorts.equals(other.workerPorts));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Map<String, String> getNodeHost(Map<String, SupervisorInfo> supInfos) {
        HashMap<String, String> rtn = new HashMap<String, String>();
        for (Map.Entry<String, SupervisorInfo> entry : supInfos.entrySet()) {
            SupervisorInfo superinfo = entry.getValue();
            String supervisorid = entry.getKey();
            rtn.put(supervisorid, superinfo.getHostName());
        }
        return rtn;
    }
}

