/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import backtype.storm.generated.StormTopology;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import clojure.lang.Atom;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMaker {
    private static Logger LOG = LoggerFactory.getLogger(ContextMaker.class);
    private WorkerData workerData;
    private String resourcePath;
    private String pidDir;
    private String codeDir;
    private List<Integer> workerTasks;

    public ContextMaker(WorkerData workerData) {
        this.workerData = workerData;
        this.workerTasks = JStormUtils.mk_list(workerData.getTaskids());
        try {
            Map<Object, Object> stormConf = workerData.getStormConf();
            String topologyId = workerData.getTopologyId();
            String workerId = workerData.getWorkerId();
            String distroot = StormConfig.supervisor_stormdist_root(stormConf, topologyId);
            this.resourcePath = StormConfig.supervisor_storm_resources_path(distroot);
            this.pidDir = StormConfig.worker_pids_root(stormConf, workerId);
            String codePath = StormConfig.stormcode_path(distroot);
            this.codeDir = PathUtils.parent_path(codePath);
        }
        catch (IOException e) {
            LOG.error("Failed to create ContextMaker", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public TopologyContext makeTopologyContext(StormTopology topology, Integer taskId, Atom openOrPrepareWasCalled) {
        Map<Object, Object> stormConf = this.workerData.getStormConf();
        String topologyId = this.workerData.getTopologyId();
        HashMap<String, Map<String, Fields>> componentToStreamToFields = this.workerData.generatecomponentToStreamToFields(topology);
        return new TopologyContext(topology, stormConf, this.workerData.getTasksToComponent(), this.workerData.getComponentToSortedTasks(), componentToStreamToFields, topologyId, this.resourcePath, this.pidDir, taskId, this.workerData.getPort(), this.workerTasks, this.workerData.getDefaultResources(), this.workerData.getUserResources(), this.workerData.getExecutorData(), this.workerData.getRegisteredMetrics(), openOrPrepareWasCalled, this.workerData.getZkCluster());
    }
}

