/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import backtype.storm.tuple.Tuple;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormDebugger {
    private static Logger LOG = LoggerFactory.getLogger(JStormDebugger.class);
    public static volatile boolean isDebug = false;
    public static volatile boolean isDebugRecv = false;
    public static volatile double sampleRate = 1.0;
    private static final int PRECISION = 10000;

    public static boolean isDebug(Long root_id) {
        return isDebug && JStormDebugger.sample(root_id);
    }

    public static boolean isDebug(Set<Long> root_ids) {
        return isDebug && JStormDebugger.sample(root_ids);
    }

    public static boolean isDebug(Collection<Tuple> anchors) {
        return isDebug && JStormDebugger.sample(anchors);
    }

    public static boolean isDebug(Object id) {
        return isDebug && JStormDebugger.sample(id);
    }

    public static boolean isDebugRecv(Set<Long> root_ids) {
        return isDebugRecv && JStormDebugger.sample(root_ids);
    }

    public static boolean isDebugRecv(Collection<Tuple> anchors) {
        return isDebugRecv && JStormDebugger.sample(anchors);
    }

    public static boolean isDebugRecv(Object id) {
        return isDebugRecv && JStormDebugger.sample(id);
    }

    private static boolean sample(Long root_id) {
        int threshold;
        if (Double.compare(sampleRate, 1.0) >= 0) {
            return true;
        }
        int mod = (int)(Math.abs(root_id) % 10000L);
        return mod < (threshold = (int)(sampleRate * 10000.0));
    }

    private static boolean sample(Set<Long> root_ids) {
        if (Double.compare(sampleRate, 1.0) >= 0) {
            return true;
        }
        int threshold = (int)(sampleRate * 10000.0);
        for (Long id : root_ids) {
            int mod = (int)(Math.abs(id) % 10000L);
            if (mod >= threshold) continue;
            return true;
        }
        return false;
    }

    private static boolean sample(Collection<Tuple> anchors) {
        if (Double.compare(sampleRate, 1.0) >= 0) {
            return true;
        }
        for (Tuple t : anchors) {
            if (!JStormDebugger.sample(t.getMessageId().getAnchors())) continue;
            return true;
        }
        return false;
    }

    private static boolean sample(Object id) {
        if (Double.compare(sampleRate, 1.0) >= 0) {
            return true;
        }
        return id != null && id instanceof Long && JStormDebugger.sample((Long)id);
    }

    public static void update(Map conf) {
        double _sampleRate;
        boolean _isDebugRecv;
        boolean _isDebug = JStormUtils.parseBoolean(conf.get("topology.debug"), isDebug);
        if (_isDebug != isDebug) {
            isDebug = _isDebug;
            LOG.info("switch topology.debug to {}", (Object)_isDebug);
        }
        if ((_isDebugRecv = ConfigExtension.isTopologyDebugRecvTuple(conf).booleanValue()) != isDebugRecv) {
            isDebugRecv = _isDebugRecv;
            LOG.info("switch topology.debug.recv.tuple to {}", (Object)_isDebug);
        }
        if (Double.compare(_sampleRate = ConfigExtension.getTopologyDebugSampleRate(conf), sampleRate) != 0) {
            sampleRate = _sampleRate;
            LOG.info("switch topology.debug.sample.rate to {}", (Object)_sampleRate);
        }
    }
}

