/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import com.alibaba.jstorm.daemon.worker.WorkerShutdown;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSimulator {
    private static Logger LOG = LoggerFactory.getLogger(ProcessSimulator.class);
    protected static Object lock = new Object();
    protected static ConcurrentHashMap<String, WorkerShutdown> processMap = new ConcurrentHashMap();

    public static void registerProcess(String pid, WorkerShutdown shutdownable) {
        processMap.put(pid, shutdownable);
    }

    protected static WorkerShutdown getProcessHandle(String pid) {
        return processMap.get(pid);
    }

    protected static Collection<WorkerShutdown> GetAllProcessHandles() {
        return processMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcess(String pid) {
        Object object = lock;
        synchronized (object) {
            LOG.info("Begin killing process " + pid);
            WorkerShutdown shutdownHandle = ProcessSimulator.getProcessHandle(pid);
            if (shutdownHandle != null) {
                shutdownHandle.shutdown();
            }
            processMap.remove(pid);
            LOG.info("Successfully killing process " + pid);
        }
    }

    public static void killAllProcesses() {
        Set pids = processMap.keySet();
        for (String pid : pids) {
            ProcessSimulator.killProcess(pid);
        }
        LOG.info("Successfully kill all processes");
    }
}

