/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.cluster.StormBase;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.task.TaskShutdownDameon;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshActive
extends RunnableCallback {
    private static Logger LOG = LoggerFactory.getLogger(RefreshActive.class);
    private WorkerData workerData;
    private AtomicBoolean shutdown;
    private AtomicBoolean monitorEnable;
    private Map<Object, Object> conf;
    private StormClusterState zkCluster;
    private String topologyId;
    private Integer frequence;

    public RefreshActive(WorkerData workerData) {
        this.workerData = workerData;
        this.shutdown = workerData.getShutdown();
        this.monitorEnable = workerData.getMonitorEnable();
        this.conf = workerData.getStormConf();
        this.zkCluster = workerData.getZkCluster();
        this.topologyId = workerData.getTopologyId();
        this.frequence = JStormUtils.parseInt(this.conf.get("task.refresh.poll.secs"), 10);
    }

    @Override
    public void run() {
        try {
            boolean workerOldStatus;
            StatusType newTopologyStatus = StatusType.activate;
            StormBase base = this.zkCluster.storm_base(this.topologyId, this);
            if (base == null) {
                LOG.warn("Failed to get StromBase from ZK of " + this.topologyId);
                newTopologyStatus = StatusType.killed;
            } else {
                newTopologyStatus = base.getStatus().getStatusType();
            }
            StatusType oldTopologyStatus = this.workerData.getTopologyStatus();
            List<TaskShutdownDameon> tasks = this.workerData.getShutdownTasks();
            if (tasks == null) {
                LOG.info("Tasks aren't ready or begin to shutdown");
                return;
            }
            boolean workerNewStatus = newTopologyStatus.equals((Object)StatusType.active) && this.workerData.getWorkeInitConnectionStatus().get();
            if (workerNewStatus != (workerOldStatus = this.workerData.getWorkerOldStatus().get())) {
                if (workerNewStatus) {
                    for (TaskShutdownDameon task : tasks) {
                        task.active();
                    }
                } else {
                    for (TaskShutdownDameon task : tasks) {
                        task.deactive();
                    }
                }
                this.workerData.getWorkerOldStatus().set(workerNewStatus);
            }
            if (newTopologyStatus.equals((Object)oldTopologyStatus)) {
                return;
            }
            LOG.info("Old TopologyStatus:" + (Object)((Object)oldTopologyStatus) + ", new TopologyStatus:" + (Object)((Object)newTopologyStatus));
            this.workerData.setTopologyStatus(newTopologyStatus);
            boolean newMonitorEnable = base.isEnableMonitor();
            boolean oldMonitorEnable = this.monitorEnable.get();
            if (newMonitorEnable != oldMonitorEnable) {
                LOG.info("Change MonitorEnable from " + oldMonitorEnable + " to " + newMonitorEnable);
                this.monitorEnable.set(newMonitorEnable);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get topology from ZK ", (Throwable)e);
            return;
        }
    }

    @Override
    public Object getResult() {
        return this.frequence;
    }
}

