/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import backtype.storm.Config;
import backtype.storm.generated.InvalidTopologyException;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.StreamInfo;
import backtype.storm.messaging.ControlMessage;
import backtype.storm.messaging.IConnection;
import backtype.storm.messaging.IContext;
import backtype.storm.messaging.TransportFactory;
import backtype.storm.scheduler.WorkerSlot;
import backtype.storm.serialization.KryoByteBufferSerializer;
import backtype.storm.serialization.KryoTupleDeserializer;
import backtype.storm.serialization.KryoTupleSerializer;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.DisruptorQueue;
import backtype.storm.utils.ThriftTopologyUtils;
import backtype.storm.utils.Utils;
import backtype.storm.utils.WorkerClassLoader;
import com.alibaba.jstorm.callback.AsyncLoopDefaultKill;
import com.alibaba.jstorm.callback.AsyncLoopThread;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.Cluster;
import com.alibaba.jstorm.cluster.ClusterState;
import com.alibaba.jstorm.cluster.Common;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.QueueGauge;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import com.alibaba.jstorm.daemon.worker.ContextMaker;
import com.alibaba.jstorm.daemon.worker.JStormDebugger;
import com.alibaba.jstorm.daemon.worker.UpdateListener;
import com.alibaba.jstorm.daemon.worker.timer.TimerTrigger;
import com.alibaba.jstorm.metric.JStormHealthReporter;
import com.alibaba.jstorm.metric.JStormMetrics;
import com.alibaba.jstorm.metric.JStormMetricsReporter;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.schedule.Assignment;
import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import com.alibaba.jstorm.task.TaskShutdownDameon;
import com.alibaba.jstorm.utils.JStormServerUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.LogUtils;
import com.alibaba.jstorm.zk.ZkTool;
import com.codahale.metrics.Gauge;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerData {
    private static Logger LOG = LoggerFactory.getLogger(WorkerData.class);
    private Map<Object, Object> conf;
    private Map<Object, Object> stormConf;
    private IContext context;
    private final String topologyId;
    private final String supervisorId;
    private final Integer port;
    private final String workerId;
    private AtomicBoolean shutdown;
    private AtomicBoolean monitorEnable;
    private StatusType topologyStatus;
    private ClusterState zkClusterstate;
    private StormClusterState zkCluster;
    private Set<Integer> taskids;
    private ConcurrentHashMap<WorkerSlot, IConnection> nodeportSocket;
    private ConcurrentHashMap<Integer, WorkerSlot> taskNodeport;
    private ConcurrentSkipListSet<ResourceWorkerSlot> workerToResource;
    private volatile Set<Integer> outboundTasks;
    private Set<Integer> localTasks;
    private Set<Integer> localNodeTasks;
    private ConcurrentHashMap<Integer, DisruptorQueue> innerTaskTransfer;
    private ConcurrentHashMap<Integer, DisruptorQueue> controlQueues;
    private ConcurrentHashMap<Integer, DisruptorQueue> deserializeQueues;
    private ConcurrentHashMap<Integer, String> tasksToComponent;
    private ConcurrentHashMap<String, List<Integer>> componentToSortedTasks;
    private Map<String, Object> defaultResources;
    private Map<String, Object> userResources;
    private Map<String, Object> executorData;
    private Map registeredMetrics;
    private StormTopology rawTopology;
    private StormTopology sysTopology;
    private ContextMaker contextMaker;
    private final AsyncLoopDefaultKill workHalt = new AsyncLoopDefaultKill();
    private DisruptorQueue transferCtrlQueue;
    private DisruptorQueue sendingQueue;
    private List<TaskShutdownDameon> shutdownTasks;
    private ConcurrentHashMap<Integer, Boolean> outTaskStatus;
    public static final int THREAD_POOL_NUM = 4;
    private ScheduledExecutorService threadPool;
    private volatile Long assignmentTS;
    private volatile Assignment.AssignmentType assignmentType;
    private IConnection recvConnection;
    private JStormMetricsReporter metricReporter;
    private AsyncLoopThread healthReporterThread;
    private AtomicBoolean workerOldStatus;
    private AtomicBoolean workeInitConnectionStatus;
    private AtomicReference<KryoTupleSerializer> atomKryoSerializer = new AtomicReference();
    private AtomicReference<KryoTupleDeserializer> atomKryoDeserializer = new AtomicReference();
    private UpdateListener updateListener;

    public WorkerData(Map conf, IContext context, String topology_id, String supervisor_id, int port, String worker_id, String jar_path) throws Exception {
        this.conf = conf;
        this.context = context;
        this.topologyId = topology_id;
        this.supervisorId = supervisor_id;
        this.port = port;
        this.workerId = worker_id;
        this.shutdown = new AtomicBoolean(false);
        this.monitorEnable = new AtomicBoolean(true);
        this.topologyStatus = StatusType.active;
        this.workerOldStatus = new AtomicBoolean(false);
        this.workeInitConnectionStatus = new AtomicBoolean(false);
        if (StormConfig.cluster_mode(conf).equals("distributed")) {
            String pidDir = StormConfig.worker_pids_root(conf, worker_id);
            JStormServerUtils.createPid(pidDir);
        }
        this.zkClusterstate = ZkTool.mk_distributed_cluster_state(conf);
        this.zkCluster = Cluster.mk_storm_cluster_state(this.zkClusterstate);
        Map rawConf = StormConfig.read_supervisor_topology_conf(conf, topology_id);
        this.stormConf = new HashMap<Object, Object>();
        this.stormConf.putAll(conf);
        this.stormConf.putAll(rawConf);
        JStormDebugger.update(this.stormConf);
        this.registerUpdateListeners();
        JStormMetrics.setTopologyId(topology_id);
        JStormMetrics.setPort(port);
        JStormMetrics.setDebug(ConfigExtension.isEnableMetricDebug(this.stormConf));
        JStormMetrics.enabled = ConfigExtension.isEnableMetrics(this.stormConf);
        JStormMetrics.enableStreamMetrics = ConfigExtension.isEnableStreamMetrics(this.stormConf);
        JStormMetrics.addDebugMetrics(ConfigExtension.getDebugMetricNames(this.stormConf));
        AsmMetric.setSampleRate(ConfigExtension.getMetricSampleRate(this.stormConf));
        ConfigExtension.setLocalSupervisorId(this.stormConf, this.supervisorId);
        ConfigExtension.setLocalWorkerId(this.stormConf, this.workerId);
        ConfigExtension.setLocalWorkerPort(this.stormConf, port);
        ControlMessage.setPort(port);
        JStormMetrics.registerWorkerTopologyMetric(JStormMetrics.workerMetricName("CpuUsedRatio", MetricType.GAUGE), new AsmGauge(new Gauge<Double>(){

            public Double getValue() {
                return JStormUtils.getCpuUsage();
            }
        }));
        JStormMetrics.registerWorkerTopologyMetric(JStormMetrics.workerMetricName("HeapMemory", MetricType.GAUGE), new AsmGauge(new Gauge<Double>(){

            public Double getValue() {
                return JStormUtils.getJVMHeapMemory();
            }
        }));
        JStormMetrics.registerWorkerTopologyMetric(JStormMetrics.workerMetricName("MemoryUsed", MetricType.GAUGE), new AsmGauge(new Gauge<Double>(){

            public Double getValue() {
                return JStormUtils.getMemUsage();
            }
        }));
        LOG.info("Worker Configuration " + this.stormConf);
        try {
            boolean enableClassloader = ConfigExtension.isEnableTopologyClassLoader(this.stormConf);
            boolean enableDebugClassloader = ConfigExtension.isEnableClassloaderDebug(this.stormConf);
            if (jar_path == null && enableClassloader && !conf.get("storm.cluster.mode").equals("local")) {
                LOG.error("enable classloader, but not app jar");
                throw new InvalidParameterException();
            }
            URL[] urlArray = new URL[]{};
            if (jar_path != null) {
                String[] paths = jar_path.split(":");
                HashSet<URL> urls = new HashSet<URL>();
                for (String path : paths) {
                    if (StringUtils.isBlank((String)path)) continue;
                    URL url = new URL("File:" + path);
                    urls.add(url);
                }
                urlArray = urls.toArray(new URL[0]);
            }
            WorkerClassLoader.mkInstance(urlArray, ClassLoader.getSystemClassLoader(), ClassLoader.getSystemClassLoader().getParent(), enableClassloader, enableDebugClassloader);
        }
        catch (Exception e) {
            LOG.error("init jarClassLoader error!", (Throwable)e);
            throw new InvalidParameterException();
        }
        Config.registerSerialization(this.stormConf, "java.nio.HeapByteBuffer", KryoByteBufferSerializer.class);
        if (this.context == null) {
            this.context = TransportFactory.makeContext(this.stormConf);
        }
        boolean disruptorUseSleep = ConfigExtension.isDisruptorUseSleep(this.stormConf);
        DisruptorQueue.setUseSleep(disruptorUseSleep);
        boolean isLimited = ConfigExtension.getTopologyBufferSizeLimited(this.stormConf);
        DisruptorQueue.setLimited(isLimited);
        LOG.info("Disruptor use sleep:" + disruptorUseSleep + ", limited size:" + isLimited);
        int queueSize = JStormUtils.parseInt(this.stormConf.get("topology.ctrl.buffer.size"), 256);
        WaitStrategy waitStrategy = (WaitStrategy)JStormUtils.createDisruptorWaitStrategy(this.stormConf);
        this.transferCtrlQueue = DisruptorQueue.mkInstance("TotalTransfer", ProducerType.MULTI, queueSize, waitStrategy);
        QueueGauge transferCtrlGauge = new QueueGauge(this.transferCtrlQueue, "SendCtrlQueue");
        JStormMetrics.registerWorkerMetric(JStormMetrics.workerMetricName("SendCtrlQueue", MetricType.GAUGE), new AsmGauge(transferCtrlGauge));
        int buffer_size = Utils.getInt(this.stormConf.get("topology.transfer.buffer.size"));
        this.sendingQueue = DisruptorQueue.mkInstance("TotalSending", ProducerType.MULTI, buffer_size, waitStrategy);
        this.nodeportSocket = new ConcurrentHashMap();
        this.taskNodeport = new ConcurrentHashMap();
        this.workerToResource = new ConcurrentSkipListSet();
        this.innerTaskTransfer = new ConcurrentHashMap();
        this.controlQueues = new ConcurrentHashMap();
        this.deserializeQueues = new ConcurrentHashMap();
        this.tasksToComponent = new ConcurrentHashMap();
        this.componentToSortedTasks = new ConcurrentHashMap();
        Assignment assignment = this.zkCluster.assignment_info(this.topologyId, null);
        if (assignment == null) {
            String errMsg = "Failed to get Assignment of " + this.topologyId;
            LOG.error(errMsg);
            throw new RuntimeException(errMsg);
        }
        this.workerToResource.addAll(assignment.getWorkers());
        this.taskids = assignment.getCurrentWorkerTasks(this.supervisorId, port);
        if (this.taskids.size() == 0) {
            throw new RuntimeException("No tasks running current workers");
        }
        LOG.info("Current worker taskList:" + this.taskids);
        this.rawTopology = StormConfig.read_supervisor_topology_code(conf, topology_id);
        this.sysTopology = Common.system_topology(this.stormConf, this.rawTopology);
        this.generateMaps();
        this.contextMaker = new ContextMaker(this);
        this.outTaskStatus = new ConcurrentHashMap();
        this.threadPool = Executors.newScheduledThreadPool(4);
        TimerTrigger.setScheduledExecutorService(this.threadPool);
        if (!StormConfig.local_mode(this.stormConf)) {
            this.healthReporterThread = new AsyncLoopThread(new JStormHealthReporter(this));
        }
        try {
            Long tmp = StormConfig.read_supervisor_topology_timestamp(conf, topology_id);
            this.assignmentTS = tmp == null ? System.currentTimeMillis() : tmp;
        }
        catch (FileNotFoundException e) {
            this.assignmentTS = System.currentTimeMillis();
        }
        this.outboundTasks = new HashSet<Integer>();
        this.updateKryoSerializer();
        LOG.info("Successfully create WorkerData");
    }

    private void registerUpdateListeners() {
        this.updateListener = new UpdateListener();
        this.updateListener.registerUpdater(new UpdateListener.IUpdater(){

            @Override
            public void update(Map conf) {
                WorkerData.this.metricReporter.updateMetricConfig(conf);
            }
        });
        this.updateListener.registerUpdater(new UpdateListener.IUpdater(){

            @Override
            public void update(Map conf) {
                JStormDebugger.update(conf);
            }
        });
        this.updateListener.registerUpdater(new UpdateListener.IUpdater(){

            @Override
            public void update(Map conf) {
                LogUtils.update(conf);
            }
        });
    }

    public UpdateListener getUpdateListener() {
        return this.updateListener;
    }

    public void updateKryoSerializer() {
        HashMap<String, Map<String, Fields>> componentToStreamToFields = this.generatecomponentToStreamToFields(this.sysTopology);
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(this.sysTopology, this.stormConf, this.tasksToComponent, this.componentToSortedTasks, componentToStreamToFields, this.topologyId);
        KryoTupleDeserializer kryoTupleDeserializer = new KryoTupleDeserializer(this.stormConf, topologyContext);
        KryoTupleSerializer kryoTupleSerializer = new KryoTupleSerializer(this.stormConf, topologyContext);
        this.atomKryoDeserializer.getAndSet(kryoTupleDeserializer);
        this.atomKryoSerializer.getAndSet(kryoTupleSerializer);
    }

    private void generateMaps() throws Exception {
        this.updateTaskComponentMap();
        this.defaultResources = new HashMap<String, Object>();
        this.userResources = new HashMap<String, Object>();
        this.executorData = new HashMap<String, Object>();
        this.registeredMetrics = new HashMap();
    }

    public Map<Object, Object> getRawConf() {
        return this.conf;
    }

    public AtomicBoolean getShutdown() {
        return this.shutdown;
    }

    public StatusType getTopologyStatus() {
        return this.topologyStatus;
    }

    public void setTopologyStatus(StatusType topologyStatus) {
        this.topologyStatus = topologyStatus;
    }

    public Map<Object, Object> getConf() {
        return this.stormConf;
    }

    public Map<Object, Object> getStormConf() {
        return this.stormConf;
    }

    public IContext getContext() {
        return this.context;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public String getSupervisorId() {
        return this.supervisorId;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public ClusterState getZkClusterstate() {
        return this.zkClusterstate;
    }

    public StormClusterState getZkCluster() {
        return this.zkCluster;
    }

    public Set<Integer> getTaskids() {
        return this.taskids;
    }

    public ConcurrentHashMap<WorkerSlot, IConnection> getNodeportSocket() {
        return this.nodeportSocket;
    }

    public ConcurrentHashMap<Integer, WorkerSlot> getTaskNodeport() {
        return this.taskNodeport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentSkipListSet<ResourceWorkerSlot> getWorkerToResource() {
        ConcurrentSkipListSet<ResourceWorkerSlot> concurrentSkipListSet = this.workerToResource;
        synchronized (concurrentSkipListSet) {
            return this.workerToResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerToResource(Set<ResourceWorkerSlot> workers) {
        ConcurrentSkipListSet<ResourceWorkerSlot> concurrentSkipListSet = this.workerToResource;
        synchronized (concurrentSkipListSet) {
            Object oldWorkers = this.workerToResource.clone();
            oldWorkers.removeAll(workers);
            if (oldWorkers.size() > 0) {
                this.workerToResource.removeAll(workers);
            }
            this.workerToResource.addAll(workers);
        }
    }

    public ConcurrentHashMap<Integer, DisruptorQueue> getInnerTaskTransfer() {
        return this.innerTaskTransfer;
    }

    public ConcurrentHashMap<Integer, DisruptorQueue> getDeserializeQueues() {
        return this.deserializeQueues;
    }

    public ConcurrentHashMap<Integer, DisruptorQueue> getControlQueues() {
        return this.controlQueues;
    }

    public ConcurrentHashMap<Integer, String> getTasksToComponent() {
        return this.tasksToComponent;
    }

    public StormTopology getRawTopology() {
        return this.rawTopology;
    }

    public StormTopology getSysTopology() {
        return this.sysTopology;
    }

    public ContextMaker getContextMaker() {
        return this.contextMaker;
    }

    public AsyncLoopDefaultKill getWorkHalt() {
        return this.workHalt;
    }

    public DisruptorQueue getTransferCtrlQueue() {
        return this.transferCtrlQueue;
    }

    public DisruptorQueue getSendingQueue() {
        return this.sendingQueue;
    }

    public Map<String, List<Integer>> getComponentToSortedTasks() {
        return this.componentToSortedTasks;
    }

    public Map<String, Object> getDefaultResources() {
        return this.defaultResources;
    }

    public Map<String, Object> getUserResources() {
        return this.userResources;
    }

    public Map<String, Object> getExecutorData() {
        return this.executorData;
    }

    public Map getRegisteredMetrics() {
        return this.registeredMetrics;
    }

    public List<TaskShutdownDameon> getShutdownTasks() {
        return this.shutdownTasks;
    }

    public void setShutdownTasks(List<TaskShutdownDameon> shutdownTasks) {
        this.shutdownTasks = shutdownTasks;
    }

    public void addShutdownTask(TaskShutdownDameon shutdownTask) {
        this.shutdownTasks.add(shutdownTask);
    }

    public List<TaskShutdownDameon> getShutdownDaemonbyTaskIds(Set<Integer> taskIds) {
        ArrayList<TaskShutdownDameon> ret = new ArrayList<TaskShutdownDameon>();
        for (TaskShutdownDameon shutdown : this.shutdownTasks) {
            if (!taskIds.contains(shutdown.getTaskId())) continue;
            ret.add(shutdown);
        }
        return ret;
    }

    public AtomicBoolean getWorkerOldStatus() {
        return this.workerOldStatus;
    }

    public AtomicBoolean getWorkeInitConnectionStatus() {
        return this.workeInitConnectionStatus;
    }

    public Set<Integer> getLocalTasks() {
        return this.localTasks;
    }

    public void setLocalTasks(Set<Integer> localTasks) {
        this.localTasks = localTasks;
    }

    public void initOutboundTaskStatus(Set<Integer> outboundTasks) {
        for (Integer taskId : outboundTasks) {
            this.outTaskStatus.put(taskId, false);
        }
    }

    public Map<Integer, Boolean> getOutboundTaskStatus() {
        return this.outTaskStatus;
    }

    public void addOutboundTaskStatusIfAbsent(Integer taskId) {
        this.outTaskStatus.putIfAbsent(taskId, false);
    }

    public void removeOutboundTaskStatus(Integer taskId) {
        this.outTaskStatus.remove(taskId);
    }

    public void updateOutboundTaskStatus(Integer taskId, boolean isActive) {
        this.outTaskStatus.put(taskId, isActive);
    }

    public boolean isOutboundTaskActive(Integer taskId) {
        return this.outTaskStatus.get(taskId) != null ? this.outTaskStatus.get(taskId) : false;
    }

    public ScheduledExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setAssignmentTs(Long time) {
        this.assignmentTS = time;
    }

    public Long getAssignmentTs() {
        return this.assignmentTS;
    }

    public void setAssignmentType(Assignment.AssignmentType type) {
        this.assignmentType = type;
    }

    public Assignment.AssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public void updateWorkerData(Assignment assignment) throws Exception {
        this.updateTaskIds(assignment);
        this.updateTaskComponentMap();
        this.updateStormTopology();
    }

    public void updateTaskIds(Assignment assignment) {
        this.taskids.clear();
        this.taskids.addAll(assignment.getCurrentWorkerTasks(this.supervisorId, this.port));
    }

    public Set<Integer> getLocalNodeTasks() {
        return this.localNodeTasks;
    }

    public void setLocalNodeTasks(Set<Integer> localNodeTasks) {
        this.localNodeTasks = localNodeTasks;
    }

    public void setOutboundTasks(Set<Integer> outboundTasks) {
        this.outboundTasks = outboundTasks;
    }

    public Set<Integer> getOutboundTasks() {
        return this.outboundTasks;
    }

    private void updateTaskComponentMap() throws Exception {
        Map<Integer, String> tmp = Common.getTaskToComponent(Cluster.get_all_taskInfo(this.zkCluster, this.topologyId));
        this.tasksToComponent.putAll(tmp);
        LOG.info("Updated tasksToComponentMap:" + this.tasksToComponent);
        this.componentToSortedTasks.putAll(JStormUtils.reverse_map(tmp));
        for (Map.Entry<String, List<Integer>> entry : this.componentToSortedTasks.entrySet()) {
            List<Integer> tasks = entry.getValue();
            Collections.sort(tasks);
        }
    }

    private void updateStormTopology() {
        StormTopology sysTmp;
        StormTopology rawTmp;
        try {
            rawTmp = StormConfig.read_supervisor_topology_code(this.conf, this.topologyId);
            sysTmp = Common.system_topology(this.stormConf, this.rawTopology);
        }
        catch (IOException e) {
            LOG.error("Failed to read supervisor topology code for " + this.topologyId, (Throwable)e);
            return;
        }
        catch (InvalidTopologyException e) {
            LOG.error("Failed to update sysTopology for " + this.topologyId, (Throwable)((Object)e));
            return;
        }
        this.updateTopology(this.rawTopology, rawTmp);
        this.updateTopology(this.sysTopology, sysTmp);
    }

    private void updateTopology(StormTopology oldTopology, StormTopology newTopology) {
        oldTopology.set_bolts(newTopology.get_bolts());
        oldTopology.set_spouts(newTopology.get_spouts());
        oldTopology.set_state_spouts(newTopology.get_state_spouts());
    }

    public AtomicBoolean getMonitorEnable() {
        return this.monitorEnable;
    }

    public IConnection getRecvConnection() {
        return this.recvConnection;
    }

    public void setRecvConnection(IConnection recvConnection) {
        this.recvConnection = recvConnection;
    }

    public JStormMetricsReporter getMetricsReporter() {
        return this.metricReporter;
    }

    public void setMetricsReporter(JStormMetricsReporter metricReporter) {
        this.metricReporter = metricReporter;
    }

    public HashMap<String, Map<String, Fields>> generatecomponentToStreamToFields(StormTopology topology) {
        HashMap<String, Map<String, Fields>> componentToStreamToFields = new HashMap<String, Map<String, Fields>>();
        Set<String> components = ThriftTopologyUtils.getComponentIds(topology);
        for (String component : components) {
            HashMap<String, Fields> streamToFieldsMap = new HashMap<String, Fields>();
            Map<String, StreamInfo> streamInfoMap = ThriftTopologyUtils.getComponentCommon(topology, component).get_streams();
            for (Map.Entry<String, StreamInfo> entry : streamInfoMap.entrySet()) {
                String streamId = entry.getKey();
                StreamInfo streamInfo = entry.getValue();
                streamToFieldsMap.put(streamId, new Fields(streamInfo.get_output_fields()));
            }
            componentToStreamToFields.put(component, streamToFieldsMap);
        }
        return componentToStreamToFields;
    }

    public AtomicReference<KryoTupleDeserializer> getAtomKryoDeserializer() {
        return this.atomKryoDeserializer;
    }

    public AtomicReference<KryoTupleSerializer> getAtomKryoSerializer() {
        return this.atomKryoSerializer;
    }
}

