/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.utils.TimeFormat;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerReportError {
    private static Logger LOG = LoggerFactory.getLogger(WorkerReportError.class);
    private StormClusterState zkCluster;
    private String hostName;

    public WorkerReportError(StormClusterState _storm_cluster_state, String _hostName) {
        this.zkCluster = _storm_cluster_state;
        this.hostName = _hostName;
    }

    public void report(String topology_id, Integer worker_port, Set<Integer> tasks, String error, int errorCode) {
        try {
            Date now = new Date();
            String nowStr = TimeFormat.getSecond(now);
            String errorInfo = error + "on " + this.hostName + ":" + worker_port + "," + nowStr;
            for (Integer task : tasks) {
                this.zkCluster.report_task_error(topology_id, task, errorInfo, "fatal", errorCode);
            }
        }
        catch (Exception e) {
            LOG.error("Failed update " + worker_port + "errors to ZK" + "\n", (Throwable)e);
        }
    }
}

