/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker;

import backtype.storm.messaging.IConnection;
import backtype.storm.messaging.IContext;
import backtype.storm.scheduler.WorkerSlot;
import com.alibaba.jstorm.callback.AsyncLoopRunnable;
import com.alibaba.jstorm.callback.AsyncLoopThread;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.ClusterState;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.daemon.worker.ShutdownableDameon;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.task.TaskShutdownDameon;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerShutdown
implements ShutdownableDameon {
    private static Logger LOG = LoggerFactory.getLogger(WorkerShutdown.class);
    public static final String HOOK_SIGNAL = "USR2";
    private List<TaskShutdownDameon> shutdowntasks;
    private AtomicBoolean shutdown;
    private ConcurrentHashMap<WorkerSlot, IConnection> nodeportSocket;
    private IContext context;
    private List<AsyncLoopThread> threads;
    private StormClusterState zkCluster;
    private ClusterState cluster_state;
    private ScheduledExecutorService threadPool;
    private IConnection recvConnection;
    private Map conf;

    public WorkerShutdown(WorkerData workerData, List<AsyncLoopThread> _threads) {
        this.shutdowntasks = workerData.getShutdownTasks();
        this.threads = _threads;
        this.shutdown = workerData.getShutdown();
        this.nodeportSocket = workerData.getNodeportSocket();
        this.context = workerData.getContext();
        this.zkCluster = workerData.getZkCluster();
        this.cluster_state = workerData.getZkClusterstate();
        this.threadPool = workerData.getThreadPool();
        this.recvConnection = workerData.getRecvConnection();
        this.conf = workerData.getStormConf();
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    @Override
    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            LOG.info("Worker has been shutdown already");
            return;
        }
        if (this.recvConnection != null) {
            this.recvConnection.close();
        }
        AsyncLoopRunnable.getShutdown().set(true);
        this.threadPool.shutdown();
        if (ConfigExtension.isOutworkerDump(this.conf)) {
            this.workerDumpInfoOutput();
        }
        for (ShutdownableDameon shutdownableDameon : this.shutdowntasks) {
            shutdownableDameon.shutdown();
        }
        for (AsyncLoopThread asyncLoopThread : this.threads) {
            LOG.info("Begin to shutdown " + asyncLoopThread.getThread().getName());
            asyncLoopThread.cleanup();
            JStormUtils.sleepMs(100L);
            asyncLoopThread.interrupt();
            LOG.info("Successfully " + asyncLoopThread.getThread().getName());
        }
        for (WorkerSlot workerSlot : this.nodeportSocket.keySet()) {
            IConnection value = this.nodeportSocket.get(workerSlot);
            value.close();
        }
        this.context.term();
        try {
            this.zkCluster.disconnect();
            this.cluster_state.close();
        }
        catch (Exception e) {
            LOG.info("Shutdown error,", (Throwable)e);
        }
        JStormUtils.halt_process(0, "!!!Shutdown!!!");
    }

    public void join() throws InterruptedException {
        for (TaskShutdownDameon task : this.shutdowntasks) {
            task.join();
        }
        for (AsyncLoopThread t : this.threads) {
            t.join();
        }
    }

    @Override
    public boolean waiting() {
        Boolean isExistsWait = false;
        for (ShutdownableDameon shutdownableDameon : this.shutdowntasks) {
            if (!shutdownableDameon.waiting()) continue;
            isExistsWait = true;
            break;
        }
        for (AsyncLoopThread asyncLoopThread : this.threads) {
            if (!asyncLoopThread.isSleeping().booleanValue()) continue;
            isExistsWait = true;
            break;
        }
        return isExistsWait;
    }

    @Override
    public void run() {
        this.shutdown();
    }

    public void workerDumpInfoOutput() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String pid = runtimeMXBean.getName().split("@")[0];
        LOG.debug("worker's pid is " + pid);
        String dumpOutFile = JStormUtils.getLogFileName();
        if (dumpOutFile == null) {
            return;
        }
        dumpOutFile = dumpOutFile + ".dump";
        try {
            File file = new File(dumpOutFile);
            if (!file.exists()) {
                PathUtils.touch(dumpOutFile);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to touch " + dumpOutFile, (Throwable)e);
            return;
        }
        try {
            PrintWriter outFile = new PrintWriter(new FileWriter(dumpOutFile, true));
            StringBuilder jstackCommand = new StringBuilder();
            jstackCommand.append("jstack ");
            jstackCommand.append(pid);
            LOG.debug("Begin to execute " + jstackCommand.toString());
            String jstackOutput = JStormUtils.launchProcess(jstackCommand.toString(), new HashMap<String, String>(), false);
            outFile.println(jstackOutput);
            StringBuilder jmapCommand = new StringBuilder();
            jmapCommand.append("jmap -heap ");
            jmapCommand.append(pid);
            LOG.debug("Begin to execute " + jmapCommand.toString());
            String jmapOutput = JStormUtils.launchProcess(jmapCommand.toString(), new HashMap<String, String>(), false);
            outFile.println(jmapOutput);
        }
        catch (Exception e) {
            LOG.error("can't excute jstack and jmap about " + pid);
            LOG.error(String.valueOf(e));
        }
    }
}

