/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker.hearbeat;

import com.alibaba.jstorm.callback.AsyncLoopThread;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncContainerHb
extends RunnableCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SyncContainerHb.class);
    private String readDir;
    private String writeDir;
    private int timeoutSeconds = 60;
    private int frequence = 10;
    private int reserverNum = 10;
    private int noContainerHbTimes = 0;
    private boolean isFirstRead = true;
    private static final int SECOND_MILLISCOND = 1000;
    private static final int MAX_NO_CONTAINER_HB_TIMES = 30;

    public void removeOld(List<String> fileList, String dir) {
        if (fileList.size() <= this.reserverNum) {
            return;
        }
        int removeNum = fileList.size() - this.reserverNum;
        for (int i = 0; i < removeNum; ++i) {
            String fileName = fileList.get(i);
            String filePath = dir + File.separator + fileName;
            try {
                PathUtils.rmpath(filePath);
            }
            catch (Exception e) {
                LOG.error("Failed to delete " + filePath, (Throwable)e);
            }
            LOG.info("Remove hearbeat file " + filePath);
        }
    }

    public void checkNoContainerHbTimes() {
        ++this.noContainerHbTimes;
        if (this.noContainerHbTimes >= 30) {
            LOG.info("It's long time no container hearbeat");
            throw new RuntimeException("It's long time no container hearbeat");
        }
    }

    public void handlReadDir() {
        if (StringUtils.isBlank((String)this.readDir)) {
            return;
        }
        File file = new File(this.readDir);
        if (!file.exists()) {
            LOG.info(this.readDir + " doesn't exist right now");
            this.checkNoContainerHbTimes();
            return;
        }
        if (!file.isDirectory()) {
            String msg = this.readDir + " isn't dir";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        String[] files = file.list();
        if (files.length == 0) {
            LOG.info(this.readDir + " doesn't contain hearbeat files right now");
            this.checkNoContainerHbTimes();
            return;
        }
        this.noContainerHbTimes = 0;
        List<String> fileList = JStormUtils.mk_list(files);
        Collections.sort(fileList);
        String biggest = fileList.get(fileList.size() - 1);
        long now = System.currentTimeMillis() / 1000L;
        long hb = 0L;
        try {
            hb = Long.valueOf(biggest);
        }
        catch (Exception e) {
            LOG.info("Heartbeat file " + biggest + " isn't a valid file, remove it");
            String path = this.readDir + File.separator + biggest;
            try {
                PathUtils.rmpath(path);
            }
            catch (Exception e1) {
                LOG.error("Failed to delete " + path, (Throwable)e1);
            }
        }
        if (now - hb > (long)this.timeoutSeconds) {
            if (this.isFirstRead) {
                this.checkNoContainerHbTimes();
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("It's long time no container's hearbeat, ");
            sb.append("ContainerDir:").append(this.readDir);
            sb.append(",last hearbeat:").append(biggest);
            LOG.error(sb.toString());
            throw new RuntimeException(sb.toString());
        }
        this.isFirstRead = false;
        LOG.info("Receive container hearbeat " + biggest);
    }

    public void handleWriteDir() {
        if (StringUtils.isBlank((String)this.writeDir)) {
            return;
        }
        String seconds = String.valueOf(System.currentTimeMillis() / 1000L);
        String path = this.writeDir + File.separator + seconds;
        try {
            PathUtils.touch(path);
            LOG.info("Successfully touch " + path);
        }
        catch (IOException e) {
            LOG.error("Failed to touch " + path, (Throwable)e);
            throw new RuntimeException("Failed to touch " + path);
        }
        File file = new File(this.writeDir);
        String[] files = file.list();
        if (files.length == 0) {
            LOG.info(this.readDir + " doesn't contain hearbeat files right now");
            return;
        }
        List<String> fileList = JStormUtils.mk_list(files);
        Collections.sort(fileList);
        this.removeOld(fileList, this.writeDir);
    }

    @Override
    public void run() {
        this.handleWriteDir();
        this.handlReadDir();
    }

    @Override
    public void shutdown() {
        this.frequence = -1;
        LOG.info("Shutdown sync container thread");
    }

    @Override
    public Object getResult() {
        return this.frequence;
    }

    public String getReadDir() {
        return this.readDir;
    }

    public void resetReadHeatbeats() {
        String[] files;
        File file = new File(this.readDir);
        if (!file.exists()) {
            LOG.info("Read hearbeat directory hasn't been created " + this.readDir);
            return;
        }
        if (!file.isDirectory()) {
            LOG.error(this.readDir + " isn't a directory ");
            throw new RuntimeException(this.readDir + " isn't a directory ");
        }
        for (String fileName : files = file.list()) {
            String path = this.readDir + File.separator + fileName;
            try {
                PathUtils.rmr(path);
            }
            catch (IOException e) {
                LOG.error("Failed to remove " + path, (Throwable)e);
            }
        }
        LOG.info("Successfully reset read heatbeats " + this.readDir);
    }

    public void setReadDir(String readDir) {
        this.readDir = readDir;
        if (StringUtils.isBlank((String)readDir)) {
            LOG.warn("ReadDir is empty");
            return;
        }
        LOG.info("ReadDir is " + readDir);
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public int getFrequence() {
        return this.frequence;
    }

    public void setFrequence(int frequence) {
        this.frequence = frequence;
    }

    public String getWriteDir() {
        return this.writeDir;
    }

    public void setWriteDir(String writeDir) {
        this.writeDir = writeDir;
        if (StringUtils.isBlank((String)writeDir)) {
            LOG.warn("writeDir is empty");
            return;
        }
        LOG.info("writeDir is " + writeDir);
        File file = new File(writeDir);
        if (!file.exists()) {
            file.mkdirs();
            LOG.info("Create Directory " + writeDir);
            return;
        }
        if (!file.isDirectory()) {
            LOG.error(writeDir + " isn't a directory ");
            throw new RuntimeException(writeDir + " isn't a directory ");
        }
    }

    public int getReserverNum() {
        return this.reserverNum;
    }

    public void setReserverNum(int reserverNum) {
        this.reserverNum = reserverNum;
    }

    public static AsyncLoopThread mkInstance(String containerHbDir, String hbDir, int timeout, int frequence) {
        SyncContainerHb syncContainerHbThread = new SyncContainerHb();
        syncContainerHbThread.setReadDir(containerHbDir);
        syncContainerHbThread.setWriteDir(hbDir);
        syncContainerHbThread.setTimeoutSeconds(timeout);
        syncContainerHbThread.setFrequence(frequence);
        StringBuilder sb = new StringBuilder();
        sb.append("Run process under Apsara/Yarn container");
        sb.append("ContainerDir:").append(containerHbDir);
        sb.append("MyDir:").append(hbDir);
        sb.append(", timeout:").append(timeout);
        sb.append(",frequence:").append(frequence);
        LOG.info(sb.toString());
        AsyncLoopThread thread = new AsyncLoopThread(syncContainerHbThread, true, 5, true);
        return thread;
    }

    public static AsyncLoopThread mkNimbusInstance(Map conf) throws IOException {
        boolean isEnable = ConfigExtension.isEnableContainerNimbus();
        if (!isEnable) {
            LOG.info("Run nimbus without Apsara/Yarn container");
            return null;
        }
        String containerHbDir = ConfigExtension.getContainerNimbusHearbeat();
        String hbDir = StormConfig.masterHearbeatForContainer(conf);
        int timeout = ConfigExtension.getContainerHeartbeatTimeoutSeconds(conf);
        int frequence = ConfigExtension.getContainerHeartbeatFrequence(conf);
        return SyncContainerHb.mkInstance(containerHbDir, hbDir, timeout, frequence);
    }

    public static AsyncLoopThread mkSupervisorInstance(Map conf) throws IOException {
        boolean isEnableContainer = ConfigExtension.isEnableContainerSupervisor();
        if (isEnableContainer) {
            String containerHbDir = ConfigExtension.getContainerSupervisorHearbeat();
            String hbDir = StormConfig.supervisorHearbeatForContainer(conf);
            int timeout = ConfigExtension.getContainerHeartbeatTimeoutSeconds(conf);
            int frequence = ConfigExtension.getContainerHeartbeatFrequence(conf);
            return SyncContainerHb.mkInstance(containerHbDir, hbDir, timeout, frequence);
        }
        boolean isWorkerAutomaticStop = ConfigExtension.isWorkerStopWithoutSupervisor(conf);
        if (isWorkerAutomaticStop) {
            String containerHbDir = null;
            String hbDir = StormConfig.supervisorHearbeatForContainer(conf);
            int timeout = ConfigExtension.getContainerHeartbeatTimeoutSeconds(conf);
            int frequence = ConfigExtension.getContainerHeartbeatFrequence(conf);
            return SyncContainerHb.mkInstance(containerHbDir, hbDir, timeout, frequence);
        }
        LOG.info("Run Supervisor without Apsara/Yarn container");
        return null;
    }

    public static AsyncLoopThread mkWorkerInstance(Map conf) throws IOException {
        boolean isEnableContainer = ConfigExtension.isEnableContainerSupervisor();
        boolean isWorkerAutomaticStop = ConfigExtension.isWorkerStopWithoutSupervisor(conf);
        if (!isEnableContainer && !isWorkerAutomaticStop) {
            LOG.info("Run worker without Apsara/Yarn container");
            return null;
        }
        String containerHbDir = StormConfig.supervisorHearbeatForContainer(conf);
        String hbDir = null;
        int timeout = ConfigExtension.getContainerHeartbeatTimeoutSeconds(conf);
        int frequence = ConfigExtension.getContainerHeartbeatFrequence(conf);
        return SyncContainerHb.mkInstance(containerHbDir, hbDir, timeout, frequence);
    }
}

