/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker.hearbeat;

import backtype.storm.utils.LocalState;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.daemon.worker.WorkerHeartbeat;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerHeartbeatRunable
extends RunnableCallback {
    private static Logger LOG = LoggerFactory.getLogger(WorkerHeartbeatRunable.class);
    private WorkerData workerData;
    private AtomicBoolean shutdown;
    private Map<Object, Object> conf;
    private String worker_id;
    private Integer port;
    private String topologyId;
    private CopyOnWriteArraySet<Integer> task_ids;
    private Integer frequence;
    private Map<String, LocalState> workerStates;

    public WorkerHeartbeatRunable(WorkerData workerData) {
        this.workerData = workerData;
        this.conf = workerData.getStormConf();
        this.worker_id = workerData.getWorkerId();
        this.port = workerData.getPort();
        this.topologyId = workerData.getTopologyId();
        this.task_ids = new CopyOnWriteArraySet<Integer>(workerData.getTaskids());
        this.shutdown = workerData.getShutdown();
        String key = "worker.heartbeat.frequency.secs";
        this.frequence = JStormUtils.parseInt(this.conf.get(key), 10);
        this.workerStates = new HashMap<String, LocalState>();
    }

    private LocalState getWorkerState() throws IOException {
        LocalState state = this.workerStates.get(this.worker_id);
        if (state == null) {
            state = StormConfig.worker_state(this.conf, this.worker_id);
            this.workerStates.put(this.worker_id, state);
        }
        return state;
    }

    public void doHeartbeat() throws IOException {
        int currtime = TimeUtils.current_time_secs();
        WorkerHeartbeat hb = new WorkerHeartbeat(currtime, this.topologyId, this.task_ids, this.port);
        LOG.debug("Doing heartbeat:" + this.worker_id + ",port:" + this.port + ",hb" + hb.toString());
        LocalState state = this.getWorkerState();
        state.put("worker-heartbeat", hb);
    }

    @Override
    public void run() {
        try {
            this.doHeartbeat();
        }
        catch (IOException e) {
            LOG.error("work_heart_beat_fn fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getResult() {
        return this.frequence;
    }
}

