/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker.timer;

import backtype.storm.utils.DisruptorQueue;
import com.alibaba.jstorm.daemon.worker.timer.TimerTrigger;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatingMapTrigger
extends TimerTrigger {
    private static final Logger LOG = LoggerFactory.getLogger(RotatingMapTrigger.class);
    public static final String ROTATINGMAP_STREAMID = "__rotating_tick";

    public RotatingMapTrigger(Map conf, String name, DisruptorQueue queue) {
        this.name = name;
        this.queue = queue;
        this.opCode = 1;
        int msgTimeOut = JStormUtils.parseInt(conf.get("topology.message.timeout.secs"), 30);
        this.frequence = msgTimeOut / 2;
        if (this.frequence <= 0) {
            this.frequence = 1;
        }
        this.firstTime = JStormUtils.parseInt(conf.get("supervisor.worker.start.timeout.secs"), 120);
        this.firstTime += this.frequence;
    }

    @Override
    public void updateObject() {
        this.object = new Tick(this.name);
    }

    public static class Tick {
        private final long time;
        private final String name;

        public Tick(String name) {
            this.name = name;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }

        public String getName() {
            return this.name;
        }
    }
}

