/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker.timer;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.TupleImplExt;
import backtype.storm.tuple.Values;
import backtype.storm.utils.DisruptorQueue;
import com.alibaba.jstorm.daemon.worker.timer.TimerTrigger;
import com.alibaba.jstorm.task.UptimeComputer;
import com.alibaba.jstorm.task.error.ITaskReportErr;
import com.alibaba.jstorm.task.execute.BoltCollector;
import com.alibaba.jstorm.task.execute.spout.SpoutCollector;
import com.alibaba.jstorm.utils.IntervalCheck;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHeartbeatTrigger
extends TimerTrigger {
    private static final Logger LOG = LoggerFactory.getLogger(TaskHeartbeatTrigger.class);
    private int taskId;
    private String componentId;
    private TopologyContext sysTopologyCtx;
    private BoltCollector boltCollector = null;
    private SpoutCollector spoutCollector = null;
    private long executeThreadHbTime;
    private int taskHbTimeout;
    private ITaskReportErr reportError;
    private IntervalCheck intervalCheck;
    private UptimeComputer uptime;

    public TaskHeartbeatTrigger(Map conf, String name, DisruptorQueue controlQueue, int taskId, String componentId, TopologyContext sysTopologyCtx, ITaskReportErr reportError) {
        this.name = name;
        this.queue = controlQueue;
        this.opCode = 3;
        this.taskId = taskId;
        this.componentId = componentId;
        this.sysTopologyCtx = sysTopologyCtx;
        this.firstTime = this.frequence = JStormUtils.parseInt(conf.get("task.heartbeat.frequency.secs"), 10).intValue();
        this.executeThreadHbTime = TimeUtils.current_time_secs();
        this.taskHbTimeout = JStormUtils.parseInt(conf.get("nimbus.task.timeout.secs"), 180);
        this.intervalCheck = new IntervalCheck();
        this.intervalCheck.setInterval(this.taskHbTimeout);
        this.intervalCheck.start();
        this.reportError = reportError;
        this.uptime = new UptimeComputer();
    }

    @Override
    public void updateObject() {
        this.object = this.taskId;
    }

    @Override
    public void run() {
        try {
            this.updateObject();
            if (this.object == null) {
                LOG.info("Timer " + this.name + " 's object is null ");
                return;
            }
            if (this.intervalCheck.check()) {
                this.checkExecuteThreadHb();
            }
            if (this.componentId.equals("__topology_master")) {
                Values values = new Values(new Object[]{this.uptime.uptime()});
                TupleImplExt tuple = new TupleImplExt(this.sysTopologyCtx, values, this.taskId, "__master_task_heartbeat");
                this.queue.publish(tuple);
            } else {
                this.sendHbMsg();
            }
            this.queue.publish(new TimerTrigger.TimerEvent(this, this.opCode, this.object), false);
            LOG.debug("Offer task HB event to controlQueue, taskId=" + this.taskId);
        }
        catch (Exception e) {
            LOG.warn("Failed to publish timer event to " + this.name, (Throwable)e);
            return;
        }
        LOG.debug(" Trigger timer event to " + this.name);
    }

    public void setSpoutOutputCollector(SpoutCollector spoutCollector) {
        this.spoutCollector = spoutCollector;
    }

    public void setBoltOutputCollector(BoltCollector boltCollector) {
        this.boltCollector = boltCollector;
    }

    public void setExeThreadHbTime(long hbTime) {
        this.executeThreadHbTime = hbTime;
    }

    private void sendHbMsg() {
        List<Object> values = JStormUtils.mk_list(this.uptime.uptime());
        if (this.spoutCollector != null) {
            this.spoutCollector.emitCtrl("__master_task_heartbeat", values, null);
        } else if (this.boltCollector != null) {
            this.boltCollector.emitCtrl("__master_task_heartbeat", null, values);
        } else {
            LOG.warn("Failed to send hearbeat msg. OutputCollector has not been initialized!");
        }
    }

    private void checkExecuteThreadHb() {
        long currentTime = TimeUtils.current_time_secs();
        if (currentTime - this.executeThreadHbTime > (long)this.taskHbTimeout) {
            String error = "No response from Task-" + this.taskId + ", last report time(sec) is " + this.executeThreadHbTime;
            this.reportError.report(error, "warn", 120, 1800);
        }
    }
}

