/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.daemon.worker.timer;

import backtype.storm.utils.DisruptorQueue;
import com.lmax.disruptor.InsufficientCapacityException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerTrigger
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TimerTrigger.class);
    private static ScheduledExecutorService threadPool;
    protected String name;
    protected int opCode;
    protected int firstTime;
    protected int frequence;
    protected DisruptorQueue queue = null;
    protected Object object;
    protected boolean block = true;

    public static void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        threadPool = scheduledExecutorService;
    }

    public void register() {
        this.register(TimeUnit.SECONDS);
    }

    public void register(TimeUnit timeUnit) {
        threadPool.scheduleAtFixedRate(this, this.firstTime, this.frequence, timeUnit);
        LOG.info("Successfully register timer " + this);
    }

    public void updateObject() {
    }

    @Override
    public void run() {
        try {
            this.updateObject();
            if (this.object == null) {
                LOG.info("Timer " + this.name + " 's object is null ");
                return;
            }
            TimerEvent event = new TimerEvent(this.opCode, this.object);
            this.queue.publish(event, this.block);
        }
        catch (InsufficientCapacityException e) {
            LOG.warn("Failed to public timer event to " + this.name);
            return;
        }
        catch (Exception e) {
            LOG.warn("Failed to public timer event to " + this.name, (Throwable)e);
            return;
        }
        LOG.debug(" Trigger timer event to " + this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public int getFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(int firstTime) {
        this.firstTime = firstTime;
    }

    public int getFrequence() {
        return this.frequence;
    }

    public void setFrequence(int frequence) {
        this.frequence = frequence;
    }

    public DisruptorQueue getQueue() {
        return this.queue;
    }

    public void setQueue(DisruptorQueue queue) {
        this.queue = queue;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public class TimerEvent {
        private int opCode;
        private Object msg;

        public TimerEvent(int opCode, Object msg) {
            this.opCode = opCode;
            this.msg = msg;
        }

        public int getOpCode() {
            return this.opCode;
        }

        public Object getMsg() {
            return this.msg;
        }
    }
}

