/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.message.netty;

import backtype.storm.messaging.ControlMessage;
import backtype.storm.messaging.TaskMessage;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageBatch {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBatch.class);
    private int buffer_size;
    private ArrayList<Object> msgs;
    private int encoded_length;

    MessageBatch(int buffer_size) {
        this.buffer_size = buffer_size;
        this.msgs = new ArrayList();
        this.encoded_length = ControlMessage.EOB_MESSAGE.encodeLength();
    }

    void add(Object obj) {
        if (obj == null) {
            throw new RuntimeException("null object forbidded in message batch");
        }
        if (obj instanceof TaskMessage) {
            TaskMessage msg = (TaskMessage)obj;
            this.msgs.add(msg);
            this.encoded_length += this.msgEncodeLength(msg);
            return;
        }
        if (obj instanceof ControlMessage) {
            ControlMessage msg = (ControlMessage)((Object)obj);
            this.msgs.add((Object)msg);
            this.encoded_length += msg.encodeLength();
            return;
        }
        throw new RuntimeException("Unsuppoted object type " + obj.getClass().getName());
    }

    void remove(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof TaskMessage) {
            TaskMessage msg = (TaskMessage)obj;
            this.msgs.remove(msg);
            this.encoded_length -= this.msgEncodeLength(msg);
            return;
        }
        if (obj instanceof ControlMessage) {
            ControlMessage msg = (ControlMessage)((Object)obj);
            this.msgs.remove((Object)msg);
            this.encoded_length -= msg.encodeLength();
            return;
        }
    }

    Object get(int index) {
        return this.msgs.get(index);
    }

    boolean tryAdd(TaskMessage taskMsg) {
        if (this.encoded_length + this.msgEncodeLength(taskMsg) > this.buffer_size) {
            return false;
        }
        this.add(taskMsg);
        return true;
    }

    private int msgEncodeLength(TaskMessage taskMsg) {
        if (taskMsg == null) {
            return 0;
        }
        int size = 8;
        if (taskMsg.message() != null) {
            size += taskMsg.message().length;
        }
        return size;
    }

    boolean isFull() {
        return this.encoded_length >= this.buffer_size;
    }

    boolean isEmpty() {
        return this.msgs.isEmpty();
    }

    int size() {
        return this.msgs.size();
    }

    public int getEncoded_length() {
        return this.encoded_length;
    }

    ChannelBuffer buffer() throws Exception {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer((int)this.encoded_length));
        for (Object msg : this.msgs) {
            if (msg instanceof TaskMessage) {
                this.writeTaskMessage(bout, (TaskMessage)msg);
                continue;
            }
            ((ControlMessage)((Object)msg)).write(bout);
        }
        ControlMessage.EOB_MESSAGE.write(bout);
        bout.close();
        return bout.buffer();
    }

    private void writeTaskMessage(ChannelBufferOutputStream bout, TaskMessage message) throws Exception {
        int payload_len = 0;
        if (message.message() != null) {
            payload_len = message.message().length;
        }
        short type = message.get_type();
        bout.writeShort((int)type);
        int task_id = message.task();
        if (task_id > Short.MAX_VALUE) {
            throw new RuntimeException("Task ID should not exceed 32767");
        }
        bout.writeShort((int)((short)task_id));
        bout.writeInt(payload_len);
        if (payload_len > 0) {
            bout.write(message.message());
        }
    }
}

