/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.message.netty;

import com.alibaba.jstorm.utils.NetWorkUtils;
import java.io.Serializable;

public class NettyConnection
implements Serializable {
    protected String clientPort;
    protected String serverPort;

    public String getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(String client, int port) {
        String ip = NetWorkUtils.host2Ip(client);
        this.clientPort = ip + ":" + port;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String server, int port) {
        String ip = NetWorkUtils.host2Ip(server);
        this.serverPort = ip + ":" + port;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.clientPort == null ? 0 : this.clientPort.hashCode());
        result2 = 31 * result2 + (this.serverPort == null ? 0 : this.serverPort.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NettyConnection other = (NettyConnection)obj;
        if (this.clientPort == null ? other.clientPort != null : !this.clientPort.equals(other.clientPort)) {
            return false;
        }
        return !(this.serverPort == null ? other.serverPort != null : !this.serverPort.equals(other.serverPort));
    }

    public String toString() {
        return this.clientPort + "->" + this.serverPort;
    }

    public static String mkString(String client, int clientPort, String server, int serverPort) {
        return client + ":" + clientPort + "->" + server + ":" + serverPort;
    }
}

