/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.message.netty;

import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.message.netty.NettyClient;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectRunnable
extends RunnableCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectRunnable.class);
    private BlockingQueue<NettyClient> queue = new LinkedBlockingDeque<NettyClient>();
    private boolean closed = false;
    private Thread thread = null;

    public void pushEvent(NettyClient client) {
        this.queue.offer(client);
    }

    @Override
    public void run() {
        LOG.info("Successfully start reconnect thread");
        this.thread = Thread.currentThread();
        while (!this.closed) {
            NettyClient client = null;
            try {
                client = this.queue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (client == null) continue;
            client.doReconnect();
        }
        LOG.info("Successfully shutdown reconnect thread");
    }

    @Override
    public void shutdown() {
        this.closed = true;
        this.thread.interrupt();
    }

    @Override
    public Object getResult() {
        return -1;
    }
}

