/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.message.netty;

import com.alibaba.jstorm.message.netty.NettyClient;
import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StormClientHandler.class);
    private NettyClient client;
    private AtomicBoolean being_closed;

    StormClientHandler(NettyClient client) {
        this.client = client;
        this.being_closed = client.getBeing_closed();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Channel channel = event.getChannel();
        LOG.info("connection established to :{}, local port:{}", (Object)this.client.getRemoteAddr(), (Object)channel.getLocalAddress());
        this.client.handleResponse();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        this.client.handleResponse();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable cause = event.getCause();
        if (!this.being_closed.get()) {
            if (!(cause instanceof ConnectException)) {
                LOG.info("Connection failed:" + this.client.getRemoteAddr(), cause);
            }
            this.client.exceptionChannel(event.getChannel());
            this.client.reconnect();
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("Receive channelDisconnected to {}, channel = {}", (Object)this.client.getRemoteAddr(), (Object)e.getChannel());
        super.channelDisconnected(ctx, e);
        this.client.disconnectChannel(e.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("Connection to {} has been closed, channel = {}", (Object)this.client.getRemoteAddr(), (Object)e.getChannel());
        super.channelClosed(ctx, e);
    }
}

