/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.message.netty;

import backtype.storm.messaging.ControlMessage;
import backtype.storm.messaging.TaskMessage;
import com.alibaba.jstorm.message.netty.MessageDecoder;
import com.alibaba.jstorm.message.netty.NettyServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StormServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StormServerHandler.class);
    private NettyServer server;
    private Map<Channel, Integer> failureCounters;

    StormServerHandler(NettyServer server) {
        this.server = server;
        this.failureCounters = new ConcurrentHashMap<Channel, Integer>();
    }

    protected int getFailureCounter(Channel channel) {
        Integer num = this.failureCounters.get(channel);
        if (num == null) {
            return 0;
        }
        return num;
    }

    protected void incFailureCounter(Channel channel) {
        Integer num = this.failureCounters.get(channel);
        if (num == null) {
            num = 0;
        }
        num = num + 1;
        this.failureCounters.put(channel, num);
    }

    protected void removeFailureCounter(Channel channel) {
        this.failureCounters.remove(channel);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        LOG.info("Connection established {}", (Object)e.getChannel().getRemoteAddress());
        this.server.addChannel(e.getChannel());
    }

    public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        super.childChannelClosed(ctx, e);
        LOG.info("Connection closed {}", (Object)e.getChildChannel().getRemoteAddress());
        MessageDecoder.removeTransmitHistogram(e.getChildChannel());
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        LOG.info("Connection channelDisconnected {}", (Object)e.getChannel().getRemoteAddress());
        MessageDecoder.removeTransmitHistogram(e.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        LOG.info("Connection channelClosed {}", (Object)e.getChannel().getRemoteAddress());
        MessageDecoder.removeTransmitHistogram(e.getChannel());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object msg = e.getMessage();
        if (msg == null) {
            return;
        }
        if (msg == ControlMessage.EOB_MESSAGE) {
            if (this.server.isSyncMode()) {
                Channel channel = ctx.getChannel();
                channel.write((Object)ControlMessage.OK_RESPONSE);
            }
            return;
        }
        if (msg instanceof ControlMessage) {
            return;
        }
        try {
            this.server.enqueue((TaskMessage)msg);
        }
        catch (Exception e1) {
            LOG.warn("Failed to enqueue a request message" + e1.toString(), (Object)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (e.getChannel() != null) {
            LOG.info("Channel occur exception {}", (Object)e.getChannel().getRemoteAddress());
        }
        this.server.closeChannel(e.getChannel());
    }
}

