/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import com.alibaba.jstorm.common.metric.AsmCounter;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMeter;
import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.metric.AsmMetricFilter;
import com.alibaba.jstorm.metric.AsmMetricSet;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsmMetricRegistry
implements AsmMetricSet {
    private static final long serialVersionUID = 8184106900230111064L;
    private static final Logger LOG = LoggerFactory.getLogger(AsmMetricRegistry.class);
    protected final ConcurrentMap<String, AsmMetric> metrics = new ConcurrentHashMap<String, AsmMetric>();

    public int size() {
        return this.metrics.size();
    }

    public <T extends AsmMetric> AsmMetric register(String name, T metric) throws IllegalArgumentException {
        metric.setMetricName(name);
        AsmMetric existing = this.metrics.putIfAbsent(name, metric);
        if (existing == null) {
            LOG.info("Successfully register metric of {}", (Object)name);
            return metric;
        }
        LOG.warn("duplicate metric: {}", (Object)name);
        return existing;
    }

    public boolean remove(String name) {
        AsmMetric metric = (AsmMetric)this.metrics.remove(name);
        if (metric != null) {
            LOG.info("Successfully unregister metric of {}", (Object)name);
            return true;
        }
        return false;
    }

    public AsmMetric getMetric(String name) {
        return (AsmMetric)this.metrics.get(name);
    }

    public SortedSet<String> getMetricNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metrics.keySet()));
    }

    public SortedMap<String, AsmGauge> getGauges() {
        return this.getGauges(AsmMetricFilter.ALL);
    }

    public SortedMap<String, AsmGauge> getGauges(AsmMetricFilter filter) {
        return this.getMetrics(AsmGauge.class, filter);
    }

    public SortedMap<String, AsmCounter> getCounters() {
        return this.getCounters(AsmMetricFilter.ALL);
    }

    public SortedMap<String, AsmCounter> getCounters(AsmMetricFilter filter) {
        return this.getMetrics(AsmCounter.class, filter);
    }

    public SortedMap<String, AsmHistogram> getHistograms() {
        return this.getHistograms(AsmMetricFilter.ALL);
    }

    public SortedMap<String, AsmHistogram> getHistograms(AsmMetricFilter filter) {
        return this.getMetrics(AsmHistogram.class, filter);
    }

    public SortedMap<String, AsmMeter> getMeters() {
        return this.getMeters(AsmMetricFilter.ALL);
    }

    public SortedMap<String, AsmMeter> getMeters(AsmMetricFilter filter) {
        return this.getMetrics(AsmMeter.class, filter);
    }

    private <T extends AsmMetric> SortedMap<String, T> getMetrics(Class<T> klass, AsmMetricFilter filter) {
        TreeMap timers = new TreeMap();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!klass.isInstance(entry.getValue()) || !filter.matches((String)entry.getKey(), (AsmMetric)entry.getValue())) continue;
            timers.put(entry.getKey(), (AsmMetric)entry.getValue());
        }
        return timers;
    }

    @Override
    public Map<String, AsmMetric> getMetrics() {
        return this.metrics;
    }
}

