/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bytes {
    private static final Logger LOG = LoggerFactory.getLogger(Bytes.class);
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    public static final int ESTIMATED_HEAP_TAX = 16;

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static byte[] toBytes(ByteBuffer bb) {
        int length = bb.limit();
        byte[] result2 = new byte[length];
        System.arraycopy(bb.array(), bb.arrayOffset(), result2, 0, length);
        return result2;
    }

    public static byte[] copyBytes(byte[] bytes, int offset, int length) {
        if (offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, length);
        }
        byte[] result2 = new byte[length];
        System.arraycopy(bytes, offset, result2, 0, length);
        return result2;
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(ByteBuffer buf) {
        if (buf == null) {
            return "null";
        }
        return Bytes.toStringBinary(buf.array(), buf.arrayOffset(), buf.limit());
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result2 = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                    result2.append(first.charAt(i));
                    continue;
                }
                result2.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("ISO-8859-1 not supported?", (Throwable)e);
        }
        return result2.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\' && in.length() > i + 1 && in.charAt(i + 1) == 'x') {
                char hd1 = in.charAt(i + 2);
                char hd2 = in.charAt(i + 3);
                if (!Bytes.isHexDigit(hd1) || !Bytes.isHexDigit(hd2)) continue;
                byte d = (byte)((Bytes.toBinaryFromHex((byte)hd1) << 4) + Bytes.toBinaryFromHex((byte)hd2));
                b[size++] = d;
                i += 3;
                continue;
            }
            b[size++] = (byte)ch;
        }
        byte[] b2 = new byte[size];
        System.arraycopy(b, 0, b2, 0, size);
        return b2;
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static boolean toBoolean(byte[] bytes, int offset, int length) {
        if (length != 1 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 1);
        }
        return bytes[offset] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the" + " capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return Bytes.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return Bytes.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] getBytes(ByteBuffer buf) {
        int savedPos = buf.position();
        byte[] newBytes = new byte[buf.remaining()];
        buf.get(newBytes);
        buf.position(savedPos);
        return newBytes;
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static byte toByte(byte[] bytes, int offset, int length) {
        if (length != 1 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 1);
        }
        return bytes[offset];
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result2 = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result2, 0, val.scale());
        Bytes.putBytes(result2, offset, valueBytes, 0, valueBytes.length);
        return result2;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result2 = new byte[valueBytes.length + 4];
        offset = Bytes.putInt(result2, offset, val.scale());
        return Bytes.putBytes(result2, offset, valueBytes, 0, valueBytes.length);
    }

    public static int compareTo(byte[] left, byte[] right) {
        return Bytes.compareByteArrayInLexOrder(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return Bytes.compareByteArrayInLexOrder(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    public static int compareByteArrayInLexOrder(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        if (left.length == 0) {
            return true;
        }
        if (left[left.length - 1] != right[right.length - 1]) {
            return false;
        }
        return Bytes.compareTo(left, right) == 0;
    }

    public static boolean equals(byte[] left, int leftOffset, int leftLen, byte[] right, int rightOffset, int rightLen) {
        if (left == right && leftOffset == rightOffset && leftLen == rightLen) {
            return true;
        }
        if (leftLen != rightLen) {
            return false;
        }
        if (leftLen == 0) {
            return true;
        }
        if (left[leftOffset + leftLen - 1] != right[rightOffset + rightLen - 1]) {
            return false;
        }
        return Bytes.compareByteArrayInLexOrder(left, leftOffset, leftLen, right, rightOffset, rightLen) == 0;
    }

    public static boolean startsWith(byte[] bytes, byte[] prefix) {
        return bytes != null && prefix != null && bytes.length >= prefix.length && Bytes.compareByteArrayInLexOrder(bytes, 0, prefix.length, prefix, 0, prefix.length) == 0;
    }

    public static int hashCode(byte[] b) {
        return Bytes.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length) {
        return Bytes.hashBytes(b, length);
    }

    public static int hashBytes(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int hashBytes(byte[] bytes, int length) {
        return Bytes.hashBytes(bytes, 0, length);
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int stringtoUTF8Bytes(String str, byte[] buffer) {
        int index = 0;
        for (int i = 0; i < str.length(); ++i) {
            char strChar = str.charAt(i);
            if ((strChar & 0xFF80) == 0) {
                buffer[index++] = (byte)(strChar & 0xFF);
                continue;
            }
            if ((strChar & 0xF800) == 0) {
                buffer[index++] = (byte)(strChar >> 6 | 0xC0);
                buffer[index++] = (byte)(strChar & 0x3F | 0x80);
                continue;
            }
            buffer[index++] = (byte)(strChar >> 12 | 0xE0);
            buffer[index++] = (byte)(strChar >> 6 & 0x3F | 0x80);
            buffer[index++] = (byte)(strChar & 0x3F | 0x80);
        }
        return index;
    }
}

